# Home - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/ImplementationGuide/hl7.fhir.ca.baseline | *Version*:1.2.0 |
| Draft as of 2025-10-10 | *Computable Name*:CanadianBaseline |

### Introduction

This implementation guide is provided to support the use of FHIR®© in a Canadian context.

This document is a working specification that is expected to be tested and referenced by FHIR®© system producers and implementation guide authors to enable feedback to improve the content of this guide.

As the output of a National Baseline Initiative, this implementation guide provides basic interoperability expectations for human-patient systems in the Canadian space. The goal of this specification is to expose the implementation guide author community and vendor community to a set of profiles that identify the data elements, code systems and value sets that are commonly present across Canada for a given FHIR resource (e.g., patient, medication, etc.) regardless of use case, jurisdiction or implementation.

The Canadian Baseline Profiles are not expected to be implemented "out-of-the-box". They are intended to be a starting point that more specific profiles (driven by jurisdictional, use-case, and project-specific needs) can build derived profiles from. By exposing a minimal and consistent set of expectations across local and jurisdictional guides, we intend to create a more transparent and uniform landscape for the vendor marketplace to begin aligning to.

Existing Canadian and International implementation guides (e.g., Canadian eReferral, Ontario PPR, US Core, IPS, etc.) were used as an initial frame of reference that the Canadian Baseline profiles further relaxed / constrained / extended to make sense in the Canadian context.

### Status

This guide is a **living document** that includes notes and profiles that continue to evolve as they undergo a working group review process and a Due Dillegence Review against existing Canadian FHIR Implementation Guides before being exposed to the larger FHIR community for further maturation through feedback and testing.

**The profiles are currently undergoing reconciliation after a period of community review through our Due Dillegence Review (DDR) process.**

* Information about the development and review process can be found [here](http://build.fhir.org/ig/HL7-Canada/ca-baseline/branches/master/developmentprocess.html) 
* You can follow along with our progress as a working group on the [Infocentral FHIR Implementation Working Group page](https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations)
 
* The list of which profiles have undergone DDRs against existing Canadian FHIR Implementation Guides can be found [here](http://build.fhir.org/ig/HL7-Canada/ca-baseline/branches/master/allartifacts.html)
* Proposed and past changes to profiles are tracked in the [Simplifier issue log](https://simplifier.net/cabaseline/~issues) that can be accessed after logging in to Simplifier and navigating to the issues tab of the project or desired profile. The commnunity is encouraged to review the issues and add issues of their own after reading the [review and development process page](http://build.fhir.org/ig/HL7-Canada/ca-baseline/branches/master/developmentprocess.html).
* The [GitHub repository for this CI build be found here](https://github.com/HL7-Canada/ca-baseline).

### Principles

The following principles were applied when creating the profiles:

* **Start with the profiles outlined in the US Core and avoid arbitrary differences** between Canadian and other international implementation guides to: 
* increase the opportunity for Digital Health / mHealth application reuse across North America
* reduce developer / vendor effort to adapt to Canadian requirements
 
* **Only impose additional constraints when strictly necessary** making adjustments as they make sense in the Canadian context. Aligning to the CA Baseline should not **prevent** implementors from participating in specific use cases and/or conforming to existing Canadian implementation guides
* **Provide direction** and set minimal expectations on a few common terminologies (e.g., CCDD, PCLOCD, etc.).
* **Focus on what Canadian implementations currently support** not what they "ought to support". Emerging Canadian concepts can be socialized through extensions, examples, and usage notes but should not be constrained by the Baseline as to be prescriptive.
* **Be consistent** and informed by other pan-Canadian standards where possible.

### Base vs. Baseline vs. Core

The international FHIR community is evolving towards further differentiation between the use of Base, Baseline, and Core terminology to categorize implementation guides - readers should be aware that the definitions below may be refined as formal definitions are provided by HL7 International. At the time that this implementation guide was authored, the following patterns were discerned and proposed by the CA FHIR Baseline Community:

**National Base Implementation Guides** (e.g., Australian Base, Germany Base, Netherlands Base) provide awareness of localized concepts but do not apply cardinality constraints or required binding strengths that enforce conformance to those concepts. In rare cases, cardinality constraints may be applied to elements that have been [sliced](https://www.hl7.org/fhir/profiling.html#slicing) to ensure the presence of sub-elements if a particular slice is used (ex: identified coding system). Must support flags are not utilized in Base National Profiles.

**National Baseline Implementation Guides** (e.g., Canadian Baseline) provide awareness of localized concepts and apply minimal cardinality constraints and preferred binding strengths only where appropriate and when expected given national context. In some scenarios, more restrictive constraints may be found on elements that have been [sliced](https://www.hl7.org/fhir/profiling.html#slicing) to support meaningful conformance when standard heterogenous concepts are expected (ex: fixed values for specific systems the slice applies to). Must Support flags are utilized to identify elements that are expected to be supported broadly regardless of use case.

**National Core Implementation Guides** (e.g., US Core) define a set of conformance requirements that enforce alignment to localized concepts through cardinality constraints, must support flags, and required/extensible binding strengths. Conformance to these profiles is tied to regulatory and/or contractual agreements in order to necessitate adoption to these more prescriptive specifications. To date, National "Cores" may or may not be scoped to specific use cases (e.g., Norway Core vs US Core) however they are a reflection of additional requirements that are expected to be included in implementations in a nation or region.

### CA Baseline Profiles

The list of CA Baseline Profiles can be found [**here**](allartifacts.md).

Each profile defines the minimum mandatory elements, extensions and terminology requirements that MUST be present. For each profile, requirements and guidance are given in a simple narrative summary. A formal hierarchical table that presents a logical view of the content in both a differential and snapshot view is also provided along with references to appropriate terminologies and examples.

Guidance, Capability Statements, and other have not yet been reviewed and added.

### Authors and Contributors

The CA FHIR Baseline is a community developed specification that was made possible through the efforts and dedication of so many in our [Canadian FHIR Implementer community](https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations). The true list exceeds what we've been able to capture and is expected to grow as our community reviews and refines it.

| | | |
| :--- | :--- | :--- |
| **Primary Authors** | Anyone historically involved in the authoring/development of the spec (including stream hosts) | Russ Buchanan,    Sheridan Cook,    Shamil Nizamov, Scott Prior,    Michael Savage,    Elliot Silver,    Igor Sirkovich |
| **Editors** | Anyone who has pushed updates/PRs to the spec (not otherwise an author) | Piers Hollott,    Lloyd McKenzie,    Arthur Nonay,    Mikael Rinnetmaki,    Inderpal Singh,    Garrett Stubbings |
| **Contributors** | Participants in the Entities, Medications, and Clinical Profiling Sub-Streams, Vocal contributors in governance and/or profiling calls, issue submitters | Ian Bekker,    Anne Belford,    Alex Bennett,    Michael Boivin,    Fang Cao,    Lorraine Constable,    Ramandeep Dhanoa,    Jean Duteau,    Finnie Flores,    Joel Francis,    Alex Goel,    Joanie Harper,    Maria Hu,    Anibal Jodorcovsky,    Mukesh Kashyap,    Paul Knapp,    Marc L'Arrivee,    Francis Lau,    Adesh Maharaj,    Dean Matthews,    Randy Nonay,    Ron Parker,    Anil Patel,    Melva Peters,    Rita Pyle,    Derek Ritz,    Philip Sales,    Khushwinder Sekhon,    Harsh Sharma,    Sisira De Silva,    Dan Simic,    Ken Sinn,    Janice Spence,    Erik Uittien,    Tony Waldschmidt,    Thomas Zhou |

-------

Contact: [hl7canada@infoway-inforoute.ca](mailto:hl7canada@infoway-inforoute.ca)

Feedback may be provided on [Simplifier](https://simplifier.net/CABaseline/~issues).



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.ca.baseline",
  "url" : "http://hl7.org/fhir/ca/baseline/ImplementationGuide/hl7.fhir.ca.baseline",
  "version" : "1.2.0",
  "name" : "CanadianBaseline",
  "title" : "Canadian Baseline",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-10T19:18:14+00:00",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "provides basic interoperability expectations for human-patient systems in the Canadian space.  Modeled after the US-Core implementation guide",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.ca.baseline",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "6.5.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "ips",
      "uri" : "http://hl7.org/fhir/uv/ips/ImplementationGuide/hl7.fhir.uv.ips",
      "packageId" : "hl7.fhir.uv.ips",
      "version" : "1.1.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2019+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "CI Build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "validation"
          },
          {
            "url" : "value",
            "valueString" : "show-reference-messages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "ipa-comparison"
          },
          {
            "url" : "value",
            "valueString" : "current"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/CodeSystem/aboriginalidentitytype"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/aboriginalidentitygroup"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/healthconcerncode"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/prescriptiondrugform"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/prescriptionmedicinalproduct"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/vaccinecodes"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/birthsex"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/aboriginalidentityindicator"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/encountertype"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/ethnicitycode"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/practitionerspecialty"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/qualifiedroletype"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/healthcareproviderroletype"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/ca/baseline/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2019+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "CI Build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "validation"
          },
          {
            "url" : "value",
            "valueString" : "show-reference-messages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "ipa-comparison"
          },
          {
            "url" : "value",
            "valueString" : "current"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/CodeSystem/aboriginalidentitytype"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/aboriginalidentitygroup"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/healthconcerncode"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/prescriptiondrugform"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/prescriptionmedicinalproduct"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/vaccinecodes"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/birthsex"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/aboriginalidentityindicator"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/encountertype"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/ethnicitycode"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/practitionerspecialty"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/qualifiedroletype"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://fhir.infoway-inforoute.ca/ValueSet/healthcareproviderroletype"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/ca/baseline/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "profiles",
        "name" : "Profiles",
        "description" : "Constraints on FHIR resources to be adhered to as part of the CA-Baseline implementation guide"
      },
      {
        "id" : "extensions",
        "name" : "Extensions",
        "description" : "Extensions defined as part of the CA-Baseline implementation guide"
      },
      {
        "id" : "terminology",
        "name" : "Terminology",
        "description" : "ValueSets (and Code Systems) defined for use within the CA-Baseline implementation guide"
      },
      {
        "id" : "examples",
        "name" : "Example(s)",
        "description" : "Example(s) showing the use of the CA-Baseline profiles"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-aboriginalidentitygroup"
        },
        "name" : "Aboriginal Identity Group",
        "description" : "A code classifying the person's aboriginal identity",
        "exampleBoolean" : false,
        "groupingId" : "extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-aboriginalidentityindicator"
        },
        "name" : "Aboriginal Identity Indicator",
        "description" : "A code classifying the person's self identity as an aboriginal person",
        "exampleBoolean" : false,
        "groupingId" : "extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-patientbirthsex"
        },
        "name" : "Birth Sex",
        "description" : "A code classifying the person's sex assigned at birth. Replicates the birthsex extension in US-Core-R4 for interoperability.",
        "exampleBoolean" : false,
        "groupingId" : "extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-deceased"
        },
        "name" : "Deceased",
        "description" : "Flag or date indicating that an individual is deceased.",
        "exampleBoolean" : false,
        "groupingId" : "extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-ethnicity"
        },
        "name" : "Ethnicity",
        "description" : "A code classifying the person's ethnic group or ethnicity as the category of people who identify with each other, usually on the basis of a presumed common genealogy or ancestry or on other similarities.",
        "exampleBoolean" : false,
        "groupingId" : "extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-dateestimated"
        },
        "name" : "Date Estimated Flag",
        "description" : "If true, indicates that information entered is an estimate and may not be precise.",
        "exampleBoolean" : false,
        "groupingId" : "extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-identifierversion"
        },
        "name" : "Identifier Version",
        "description" : "A version string indicating the currency/validity of an identifier.",
        "exampleBoolean" : false,
        "groupingId" : "extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-nofixedaddress"
        },
        "name" : "No Fixed Address",
        "description" : "This extension applies to the Address datatype and indicates that there is an assertion that there is no fixed address.",
        "exampleBoolean" : false,
        "groupingId" : "extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-rolestatus"
        },
        "name" : "Role Status",
        "description" : "Represents the status of the Role, as defined by the HL7v3 Role class state machine.",
        "exampleBoolean" : false,
        "groupingId" : "extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-servicelanguage"
        },
        "name" : "Service Language",
        "description" : "Indentifies languages that that services are provided in.",
        "exampleBoolean" : false,
        "groupingId" : "extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ext-statusreason"
        },
        "name" : "Status Reason",
        "description" : "Provides a textual description (reason) for a status.",
        "exampleBoolean" : false,
        "groupingId" : "extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-allergyintolerance"
        },
        "name" : "AllergyIntolerance Profile",
        "description" : "Proposed constraints and extensions on the AllergyIntolerance Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-condition"
        },
        "name" : "Condition Profile",
        "description" : "Proposed constraints and extensions on the Condition Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-device"
        },
        "name" : "Device Profile (Implantable)",
        "description" : "Proposed constraints on the Device resource for the minimal set of data to query and retrieve a patient's implantable device.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-device-medical"
        },
        "name" : "Device Profile (Medical and Non-medical)",
        "description" : "Proposed constraints on the Device resource for the minimal set of data to query and retrieve a medical or non-medical device.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-diagnosticreport"
        },
        "name" : "DiagnosticReport Profile for Laboratory Results Reporting",
        "description" : "Proposed constraints on the DiagnosticReport resource to set minimum expectations to laboratory and similar results reporting.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-documentreference"
        },
        "name" : "Document Reference Profile",
        "description" : "Proposed constraints and extensions on the DocumentReference Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-encounter"
        },
        "name" : "Encounter Profile",
        "description" : "Proposed constraints and extensions on the Encounter Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-immunization"
        },
        "name" : "Immunization Profile",
        "description" : "Proposed constraints and extensions on the Immunization Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-immunizationrecommendation"
        },
        "name" : "ImmunizationRecommendation Profile",
        "description" : "Proposed constraints and extensions on the ImmunizationRecommendation Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-location"
        },
        "name" : "Location Profile",
        "description" : "Proposed constraints and extensions on the Location Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-medication"
        },
        "name" : "Medication Profile",
        "description" : "Proposed constraints and extensions on the Medication Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-medicationadministration"
        },
        "name" : "MedicationAdministration Profile",
        "description" : "Proposed constraints and extensions on the MedicationAdministration Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-medicationdispense"
        },
        "name" : "MedicationDispense Profile",
        "description" : "Proposed constraints and extensions on the MedicationDispense Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-medicationrequest"
        },
        "name" : "MedicationRequest Profile",
        "description" : "Proposed constraints and extensions on the MedicationRequest Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-medicationstatement"
        },
        "name" : "MedicationStatement Profile",
        "description" : "Proposed constraints and extensions on the MedicationStatement Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-observation"
        },
        "name" : "Observation Profile (General)",
        "description" : "Proposed constraints and extensions on the Observation Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-observation-results"
        },
        "name" : "Observation Profile (Laboratory Results)",
        "description" : "Proposed constraints and extensions on the Observation Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-organization"
        },
        "name" : "Organization Profile",
        "description" : "Proposed constraints and extensions on the Organization Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-organizationaffiliation"
        },
        "name" : "OrganizationAffiliation Profile",
        "description" : "Proposed constraints and extensions on the OrganizationAffiliation Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-patient"
        },
        "name" : "Patient Profile",
        "description" : "Proposed constraints and extensions on the Patient Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-practitioner"
        },
        "name" : "Practitioner Profile (General)",
        "description" : "Proposed constraints and extensions on the Practitioner Resource for general use.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-practitioner-registry"
        },
        "name" : "Practitioner Profile (Provider Registry)",
        "description" : "Proposed constraints and extensions on the Practitioner Resource for use by Provider Registry systems.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-practitionerrole"
        },
        "name" : "PractitionerRole Profile (General)",
        "description" : "Proposed constraints and extensions on the PractitionerRole Resource for general use.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-practitionerrole-registry"
        },
        "name" : "PractitionerRole Profile (Provider Registry)",
        "description" : "Proposed constraints and extensions on the PractitionerRole Resource for use by Provider Registry systems.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-procedure"
        },
        "name" : "Procedure Profile",
        "description" : "Proposed constraints and extensions on the Procedure Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-servicerequest"
        },
        "name" : "ServiceRequest Profile",
        "description" : "Proposed constraints on the ServiceRequest resource for the minimal set of data required to request for service such as diagnostic investigations, treatments, or operations to be performed.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-identifier"
        },
        "name" : "Identifier DataType Profile (CA Baseline)",
        "description" : "This profile constrains the identifier data type to support minimum expectations of Canadian systems when expressing the identifier data type.",
        "exampleBoolean" : false,
        "groupingId" : "profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/aboriginalidentitytype"
        },
        "name" : "Aboriginal Identity Type",
        "description" : "Represents codes for Aboriginal Identity",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/aboriginalidentitygroup"
        },
        "name" : "Aboriginal Identity Group",
        "description" : "Represents codes for Aboriginal Identity",
        "exampleBoolean" : false,
        "groupingId" : "terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/aboriginalidentityindicator"
        },
        "name" : "Aboriginal Identity Indicator",
        "description" : "Represents the self identity as an Aboriginal Person",
        "exampleBoolean" : false,
        "groupingId" : "terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/birthsex"
        },
        "name" : "Birth Sex",
        "description" : "Codes for documenting sex at birth. (Replicates the birthsex ValueSet in US-Core-R4 for interoperability.)",
        "exampleBoolean" : false,
        "groupingId" : "terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/encountertype"
        },
        "name" : "Encounter Type",
        "description" : "The type of encounter: a specific code indicating type of service provided. This value set includes codes from SNOMED CT decending from the concept 308335008 (Patient encounter procedure (procedure))",
        "exampleBoolean" : false,
        "groupingId" : "terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/ethnicitycode"
        },
        "name" : "Ethnicity Code",
        "description" : "Codes representing a self-reported ethnic group. This should not be confused with citizenship or nationality.",
        "exampleBoolean" : false,
        "groupingId" : "terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/healthconcerncode"
        },
        "name" : "Health Concern Codes",
        "description" : "Clinical problems, conditions, diagnoses, symptoms, findings and complaints, as interpreted by the provider.",
        "exampleBoolean" : false,
        "groupingId" : "terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/prescriptiondrugform"
        },
        "name" : "Prescription Drug Form",
        "description" : "The list of forms in which compounded drugs or active ingredients can be dispensed to the patient.",
        "exampleBoolean" : false,
        "groupingId" : "terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/prescriptionmedicinalproduct"
        },
        "name" : "Prescription Medicinal Product",
        "description" : "The list of commonly used Medicinal products used for prescribing and dispensing in Canada.",
        "exampleBoolean" : false,
        "groupingId" : "terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vaccinecodes"
        },
        "name" : "Vaccine Codes",
        "description" : "**Placeholder**\\nCurrent and historical vaccines are published as separate lists by Canada Health Infoway.",
        "exampleBoolean" : false,
        "groupingId" : "terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/practitionerspecialty"
        },
        "name" : "Practitioner Specialty Codes",
        "description" : "Defines the clinical, medical, surgical or other healthcare-related service specialty of a practitioner who interacts, treats or provides such services to or for a patient.\n\nThis resource is an informative value set; a [normative subset](https://tgateway.infoway-inforoute.ca/vs/practitionerspecialty) can be found on Canada Health Infoway's [Terminology Gateway](https://tgateway.infoway-inforoute.ca).",
        "exampleBoolean" : false,
        "groupingId" : "terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/profile-diagnosticreportnote"
        },
        "name" : "Diagnostic Report for Report and Note Exchange Profile",
        "description" : "Proposed constraints and extensions on the Diagnostic Report Resource to support collection of diagnostic report information for reports and notes.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/healthcareproviderroletype"
        },
        "name" : "HealthcareProviderRoleType",
        "description" : "A role type that is used to categorize an entity that delivers health care in an expected and professional manner to an entity in need of health care services. Examples: Registered Nurse, Chiropractor, Physician, Custodial Care Clinic.\n\nThis resource is an informative value set; a [normative subset](https://tgateway.infoway-inforoute.ca/vs/healthcareproviderroletype) can be found on Canada Health Infoway's [Terminology Gateway](https://tgateway.infoway-inforoute.ca)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/qualifiedroletype"
        },
        "name" : "QualifiedRoleType",
        "description" : "A code for the degree or educational rank that the credential specifies. May also apply to an Expertise type.\n\nThis resource is an informative value set; a [normative subset](https://tgateway.infoway-inforoute.ca/vs/qualifiedroletype) can be found on Canada Health Infoway's [Terminology Gateway](https://tgateway.infoway-inforoute.ca)."
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "general-guidance.html"
            }
          ],
          "nameUrl" : "general-guidance.html",
          "title" : "General Guidance",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "developmentprocess.html"
            }
          ],
          "nameUrl" : "developmentprocess.html",
          "title" : "Development Process",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "security.html"
            }
          ],
          "nameUrl" : "security.html",
          "title" : "Security",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "allartifacts.html"
            }
          ],
          "nameUrl" : "allartifacts.html",
          "title" : "FHIR Artifacts",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "artifacts.html"
                }
              ],
              "nameUrl" : "artifacts.html",
              "title" : "Artifact List",
              "generation" : "html"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "vitalsigns-profiles.html"
                }
              ],
              "nameUrl" : "vitalsigns-profiles.html",
              "title" : "Vital Signs",
              "generation" : "markdown"
            }
          ]
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
