# Birth Sex - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Birth Sex**

## ValueSet: Birth Sex 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/ValueSet/birthsex | *Version*:1.2.0 |
| Draft as of 2019-03-08 | *Computable Name*:BirthSex |

 
Codes for documenting sex at birth. (Replicates the birthsex ValueSet in US-Core-R4 for interoperability.) 

 **References** 

* [Extension: Birth Sex](StructureDefinition-ext-patientbirthsex.md)

### Logical Definition (CLD)

 

### Expansion

This value set contains 3 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "birthsex",
  "url" : "http://hl7.org/fhir/ca/baseline/ValueSet/birthsex",
  "version" : "1.2.0",
  "name" : "BirthSex",
  "title" : "Birth Sex",
  "status" : "draft",
  "experimental" : false,
  "date" : "2019-03-08",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Codes for documenting sex at birth. (Replicates the birthsex ValueSet in US-Core-R4 for interoperability.)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-AdministrativeGender",
        "concept" : [
          {
            "code" : "F",
            "display" : "Female"
          },
          {
            "code" : "M",
            "display" : "Male"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "concept" : [
          {
            "code" : "UNK",
            "display" : "Unknown"
          }
        ]
      }
    ]
  }
}

```
