# Aboriginal Identity Indicator - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Aboriginal Identity Indicator**

## ValueSet: Aboriginal Identity Indicator 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.infoway-inforoute.ca/ValueSet/aboriginalidentityindicator | *Version*:1.2.0 |
| Draft as of 2020-09-15 | *Computable Name*:AboriginalIdentityIndicator |

 
Represents the self identity as an Aboriginal Person 

 **References** 

* [Extension: Aboriginal Identity Indicator](StructureDefinition-ext-aboriginalidentityindicator.md)

### Logical Definition (CLD)

 

### Expansion

This value set expansion contains 4 concepts.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "aboriginalidentityindicator",
  "url" : "https://fhir.infoway-inforoute.ca/ValueSet/aboriginalidentityindicator",
  "version" : "1.2.0",
  "name" : "AboriginalIdentityIndicator",
  "title" : "Aboriginal Identity Indicator",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-09-15",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Represents the self identity as an Aboriginal Person",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v2-0136"]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
        "concept" : [
          {
            "code" : "not-asked",
            "display" : "Not Asked"
          },
          {
            "code" : "asked-declined",
            "display" : "Asked But Declined"
          }
        ]
      }
    ]
  }
}

```
