# Aboriginal Identity Group - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Aboriginal Identity Group**

## ValueSet: Aboriginal Identity Group 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.infoway-inforoute.ca/ValueSet/aboriginalidentitygroup | *Version*:1.2.0 |
| Draft as of 2025-10-10 | *Computable Name*:AboriginalIdentityGroup |

 
Represents codes for Aboriginal Identity 

 **References** 

* [Extension: Aboriginal Identity Group](StructureDefinition-ext-aboriginalidentitygroup.md)

### Logical Definition (CLD)

 

### Expansion

This value set expansion contains 10 concepts.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "aboriginalidentitygroup",
  "url" : "https://fhir.infoway-inforoute.ca/ValueSet/aboriginalidentitygroup",
  "version" : "1.2.0",
  "name" : "AboriginalIdentityGroup",
  "title" : "Aboriginal Identity Group",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-10T19:18:14+00:00",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Represents codes for Aboriginal Identity",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "https://fhir.infoway-inforoute.ca/ValueSet/aboriginalidentitytype"
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
        "concept" : [
          {
            "code" : "asked-unknown",
            "display" : "Asked But Unknown"
          },
          {
            "code" : "not-asked",
            "display" : "Not Asked"
          },
          {
            "code" : "asked-declined",
            "display" : "Asked But Declined"
          }
        ]
      }
    ]
  }
}

```
