# ServiceRequest Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **ServiceRequest Profile**

## Resource Profile: ServiceRequest Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-servicerequest | *Version*:1.2.0 |
| Draft as of 2024-12-13 | *Computable Name*:ServiceRequestProfile |

 
Proposed constraints on the ServiceRequest resource for the minimal set of data required to request for service such as diagnostic investigations, treatments, or operations to be performed 

# CA ServiceRequest Profile

This Service Request Profile is based upon the core FHIR ServiceRequest resource and created to define the minimal set of data required to request for service such as diagnostic investigations, treatments, or operations to be performed.

This profile defines a service request structure that includes core localisation concepts for use as a diagnostic service request in a Canadian context.

## Mandatory Data Elements

All elements or attributes defined in FHIR have cardinality as part of their definition - a minimum number of required appearances and a maximum number.

Most elements in FHIR specification have a minimum cardinality of 0, which means that they may be missing from a resource when it is exchanged between systems.

In this Canadian Baseline ServiceRequest Profile following elements are required:

* status of the order (ServiceRequest.status)
* progression of a business activity (ServiceRequest.intent)
* on whom or what the service is to be performed (ServiceRequest.subject)
* who initiated the request (ServiceRequest.requester)

### Data Absent Reason

In situations where the minimum cardinality of an element or attribute is 1 and information is missing and the Responder knows the precise reason for the absence of data, Responders SHALL send the reason for the missing information using values (such as [NullFlavor](https://www.hl7.org/fhir/extension-iso21090-nullflavor.html)) from the value set where they exist or using the [DataAbsentReason](http://hl7.org/fhir/StructureDefinition/data-absent-reason) extension.

## Must Support Data Elements

Some elements are labeled as MustSupport meaning that implementations that produce or consume resources SHALL provide "support" for the element in some meaningful way (see [Must Support](https://build.fhir.org/ig/HL7-Canada/ca-baseline/general-guidance.html#must-support) definition).

Following elements are marked as Must Support in the Canadian ServiceRequest profile.

**Must Support elements:**

* identifier
* requisition
* status
* intent
* category
* code
* subject
* authoredOn
* requester
* performer

## Usage Note

This profile may be used to share relevant information required to support a referral or a transfer of care request from one practitioner to another in which a referral is sent directly to a specific health service described in a shared Health Services Directory.

A ServiceRequest can be supplemented with service-specific clinical decision support information and any other additionally required data, for example, available appointment slots.

**Usages:**

* Refer to this Profile: [ServiceRequest Profile for Results Reporting](StructureDefinition-profile-servicerequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-servicerequest)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-servicerequest.csv), [Excel](StructureDefinition-profile-servicerequest.xlsx), [Schematron](StructureDefinition-profile-servicerequest.sch) 

### Notes:

## Category

The **ServiceRequest.category** element conveys a code that classifies the service for searching, sorting and display purposes.

It may use Canada Health Infoway defined [InterventionCodeSubsetCare](https://tgateway.infoway-inforoute.ca/singlesubset.html?id=2.16.840.1.113883.2.20.3.271&versionid=20200930) value set to represent the care procedures performed by a Provider.

## Code

The **ServiceRequest.code** element identifies a particular service (i.e., procedure, diagnostic investigation, or panel of investigations) that have been requested.

If the service identified by the **ServiceRequest.category** is **laboratory procedure** the **pan-Canadian LOINC Observation Code Database** ([pCLOCD](https://infocentral.infoway-inforoute.ca/en/standards/canadian/pclocd-loinc)) is preferred. pCLOCD is the Canadian version of the LOINC(tm) database.

## Reason Code

The **ServiceRequest.reasonCode** element in this profile uses the same [ProcedureReasonCodes](https://www.hl7.org/fhir/valueset-procedure-reason.html) value set as defined by the FHIR standard.

The binding is chagned from [Example](https://www.hl7.org/fhir/terminologies.html#example) to [Preferred](https://www.hl7.org/fhir/terminologies.html#preferred). Implementers are encouraged to draw codes from the specified code system for interoperability purposes.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-servicerequest",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-servicerequest",
  "version" : "1.2.0",
  "name" : "ServiceRequestProfile",
  "title" : "ServiceRequest Profile for Results Reporting",
  "status" : "draft",
  "date" : "2024-12-13",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints on the ServiceRequest resource for the minimal set of data required to request for service such as diagnostic investigations, treatments, or operations to be performed",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ServiceRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ServiceRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ServiceRequest",
        "path" : "ServiceRequest",
        "short" : "ServiceRequest Profile",
        "definition" : "Service Request Profile is based upon the core FHIR ServiceRequest resource and created to define the minimal set of data required to request for service such as diagnostic investigations, treatments, or operations to be performed."
      },
      {
        "id" : "ServiceRequest.identifier",
        "path" : "ServiceRequest.identifier",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.basedOn",
        "path" : "ServiceRequest.basedOn",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-servicerequest",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationrequest"
            ]
          }
        ]
      },
      {
        "id" : "ServiceRequest.replaces",
        "path" : "ServiceRequest.replaces",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-servicerequest"
            ]
          }
        ]
      },
      {
        "id" : "ServiceRequest.requisition",
        "path" : "ServiceRequest.requisition",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.status",
        "path" : "ServiceRequest.status",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.intent",
        "path" : "ServiceRequest.intent",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.category",
        "path" : "ServiceRequest.category",
        "short" : "Classification of service",
        "definition" : "A code that classifies the service for searching, sorting and display purposes (e.g. Surgical Procedure).",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred"
        }
      },
      {
        "id" : "ServiceRequest.code",
        "path" : "ServiceRequest.code",
        "definition" : "Codes for tests or services that can be carried out by a designated individual, organization or healthcare service.  For laboratory, use of the pan-Canadian LOINC Observation Code Database (pCLOCD) is preferred and can be found in the slice below."
      },
      {
        "id" : "ServiceRequest.code.coding",
        "path" : "ServiceRequest.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "min" : 0,
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.code.coding:LabOrder",
        "path" : "ServiceRequest.code.coding",
        "sliceName" : "LabOrder",
        "short" : "Laboratory procedure code",
        "definition" : "A code that identifies a laboratory procedure that have been requested",
        "comment" : "The binding strength of this element is [Preferred](https://www.hl7.org/fhir/terminologies.html#strength), meaning that codes are encouraged to draw from the pCLOCD value set for interoperability purposes but are not required to do so to be considered conformant.",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "The pan-Canadian LOINC Observation Code Database (pCLOCD) is the Canadian version of the LOINC(tm) database. It was created using the LOINC(tm) records and attributes that were constrained for Canadian use and supplemented to specifically meet Canadian requirements. It contains the core LOINC(tm) attributes as required by Regenstrief copyright rules. The LOINC(tm) Component has been customized to meet Canadian requirements and is displayed as the pan Canadian Component Name. This component name is the basis for the pan Canadian Display Name. Core attributes are include both English and Canadian French.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/pCLOCD"
        }
      },
      {
        "id" : "ServiceRequest.code.coding:LabOrder.system",
        "path" : "ServiceRequest.code.coding.system",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ServiceRequest.code.coding:LabOrder.code",
        "path" : "ServiceRequest.code.coding.code",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ServiceRequest.code.coding:@default",
        "path" : "ServiceRequest.code.coding",
        "sliceName" : "@default"
      },
      {
        "id" : "ServiceRequest.code.coding:@default.system",
        "path" : "ServiceRequest.code.coding.system",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ServiceRequest.code.coding:@default.code",
        "path" : "ServiceRequest.code.coding.code",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ServiceRequest.subject",
        "path" : "ServiceRequest.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-location",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.encounter",
        "path" : "ServiceRequest.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-encounter"
            ]
          }
        ]
      },
      {
        "id" : "ServiceRequest.authoredOn",
        "path" : "ServiceRequest.authoredOn",
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.requester",
        "path" : "ServiceRequest.requester",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.performer",
        "path" : "ServiceRequest.performer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.locationReference",
        "path" : "ServiceRequest.locationReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-location"
            ]
          }
        ]
      },
      {
        "id" : "ServiceRequest.reasonCode",
        "path" : "ServiceRequest.reasonCode",
        "binding" : {
          "strength" : "preferred"
        }
      },
      {
        "id" : "ServiceRequest.reasonReference",
        "path" : "ServiceRequest.reasonReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-condition",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-diagnosticreport",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-diagnosticreportnote",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-documentreference"
            ]
          }
        ]
      }
    ]
  }
}

```
