# Procedure Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Procedure Profile**

## Resource Profile: Procedure Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-procedure | *Version*:1.2.0 |
| Draft as of 2024-12-13 | *Computable Name*:ProcedureProfile |

 
Proposed constraints and extensions on the Procedure Resource 

# CA Baseline Procedure Profile

> This profile is seeking broader community and implementer feedback.

The cardinality on procedure.performed[x] has been constrained to 1..1. While this did not cause any Due Diligence Review Issues with IPS or US Core, we are seeking feedback from additional implementers on whether this cardinality restriction poses problems for their FHIR implementations.

This profile also socializes an example of a subset of SNOMED CT codes for procedures that is made available through the Infoway Terminology Gateway: https://fhir.infoway-inforoute.ca/ValueSet/interventioncode. This extensional value set was developed after initial review of the profiles but has been added in. We are seeking community feedback as to whether this subset is in use today by Canadian implementers or whether or not we should point to the larger value set of SNOMED CT codes contained in the IPS Value Set.

Feedback can be provided using the[Simplifier issue log for this profile](https://simplifier.net/CanadianFHIRBaselineProfilesCA-Core/procedureprofile/~issues).

This profile sets minimum expectations for the Procedure resource to record, search and fetch current or historical procedures performed on or for a patient. It identifies which elements and value sets SHALL be present in the resource when using this profile.

This profile defines localization concepts for use in an Canadian context.

## Mandatory Data Elements

All elements or attributes defined in FHIR have cardinality as part of their definition - a minimum number of required appearances and a maximum number.

Most elements in FHIR specification have a minimum cardinality of **0**, which means that they may be missing from a resource when it is exchanged between systems.

**Required elements:**

* status specifying the state of the procedure (required in the base specification)
* code to classify the procedure that is performed
* reference to a subject
* date procedure was performed

## Must Support Data Elements

Some elements are labeled as MustSupport meaning that implementations that produce or consume resources SHALL provide "support" for the element in some meaningful way (see [Must Support](https://build.fhir.org/ig/HL7-Canada/ca-baseline/general-guidance.html#must-support) definition).

Following elements are marked as Must Support in the Procedure profile to aid record matching in databases with many pediatric records.

**Must Support elements:**

* status
* code
* reference to a subject
* performed date
* body site

## Usage Note

This Procedure profile is used to provide summary information about the occurrence of current or historical procedures performed on or for a patient, and is not intended to provide real-time snapshots of a procedure as it unfolds. Examples include surgical procedures, diagnostic procedures, endoscopic procedures, biopsies, counseling, physiotherapy, personal support services, adult day care services, non-emergency transportation, home modification, exercise and so on.

A slice for absentOrUnknownProcedure comes from the IPS-UV specification and has been socialized in the profile as a way to represent a standard set of codes for identifying absent or unknown procedures. While the profile expects that a procedure.code be present (cardinality of 1..1) the use of the slice is entirely optional.

**Usages:**

* Refer to this Profile: [Encounter Profile](StructureDefinition-profile-encounter.md), [MedicationAdministration Profile](StructureDefinition-profile-medicationadministration.md), [MedicationDispense Profile](StructureDefinition-profile-medicationdispense.md), [MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md) and [Procedure Profile](StructureDefinition-profile-procedure.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-procedure)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-procedure.csv), [Excel](StructureDefinition-profile-procedure.xlsx), [Schematron](StructureDefinition-profile-procedure.sch) 

### Notes:

## Code

The **Procedure.code** element is used to specify a procedure that is performed.

The **Procedure.code** element is [CodeableConcept](https://www.hl7.org/fhir/datatypes.html#codeableconcept) data type meaning that more than one [Coding](https://www.hl7.org/fhir/datatypes.html#codesystem) sub-elements can be present. One of these Coding sub-elements MAY use [InterventionCodeSubsetOperatingRoomProcedure](https://tgateway.infoway-inforoute.ca/vs/interventioncodesubsetoperatingroomprocedure) value set from Canada Health Infoway.

Use text if the exact nature of the procedure cannot be coded (e.g. "Laparoscopic Appendectomy").



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-procedure",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-procedure",
  "version" : "1.2.0",
  "name" : "ProcedureProfile",
  "title" : "Procedure Profile",
  "status" : "draft",
  "date" : "2024-12-13",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the Procedure Resource",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Procedure",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure",
        "path" : "Procedure",
        "short" : "Procedure Profile",
        "definition" : "The Procedure Profile is based upon the core FHIR Procedure Resource"
      },
      {
        "id" : "Procedure.partOf",
        "path" : "Procedure.partOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-procedure",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationadministration"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.status",
        "path" : "Procedure.status",
        "mustSupport" : true
      },
      {
        "id" : "Procedure.code",
        "path" : "Procedure.code",
        "definition" : "Identification of the procedure or recording of \"absence of relevant procedures\" or of \"procedures unknown\".",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "description" : "Extensional Subset of SNOMED CT and SNOMED CT CA Extension Codes to describe Services/Activities performed by Primary Health Care Providers.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/interventioncode"
        }
      },
      {
        "id" : "Procedure.code.coding",
        "path" : "Procedure.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "description" : "Discriminated by the bound value set",
          "rules" : "open"
        }
      },
      {
        "id" : "Procedure.code.coding:absentOrUnknownProcedure",
        "path" : "Procedure.code.coding",
        "sliceName" : "absentOrUnknownProcedure",
        "short" : "Code for absent problem or for unknown procedure",
        "definition" : "Code representing the statement \"absent problem\" or the statement \"procedures unknown\"",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "absentOrUnknownProcedure"
            }
          ],
          "strength" : "required",
          "description" : "A code to identify absent or unknown procedures",
          "valueSet" : "http://hl7.org/fhir/uv/ips/ValueSet/absent-or-unknown-procedures-uv-ips"
        }
      },
      {
        "id" : "Procedure.subject",
        "path" : "Procedure.subject",
        "definition" : "The person on which the procedure was performed.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.encounter",
        "path" : "Procedure.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-encounter"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.performed[x]",
        "path" : "Procedure.performed[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          },
          {
            "code" : "string"
          },
          {
            "code" : "Age"
          },
          {
            "code" : "Range"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.performed[x].extension",
        "path" : "Procedure.performed[x].extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Procedure.performed[x].extension:data-absent-reason",
        "path" : "Procedure.performed[x].extension",
        "sliceName" : "data-absent-reason",
        "short" : "performed[x] absence reason",
        "definition" : "Provides a reason why the performed is missing.",
        "comment" : "Some Canadian implementations cannot guarantee that a procedure performed date will always be available in every instance of legacy data. Any implementors who do not require a performed date be available on every procedure need to be able to produce a dataAbsentReason extension",
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/data-absent-reason"]
          }
        ]
      },
      {
        "id" : "Procedure.recorder",
        "path" : "Procedure.recorder",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.asserter",
        "path" : "Procedure.asserter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.performer.actor",
        "path" : "Procedure.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.location",
        "path" : "Procedure.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-location"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.reasonReference",
        "path" : "Procedure.reasonReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-condition",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-procedure",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-diagnosticreport",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-diagnosticreportnote",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-documentreference"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.complicationDetail",
        "path" : "Procedure.complicationDetail",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-condition"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.usedReference",
        "path" : "Procedure.usedReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medication",
              "http://hl7.org/fhir/StructureDefinition/Substance"
            ]
          }
        ]
      }
    ]
  }
}

```
