# Practitioner Profile (Provider Registry) - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Practitioner Profile (Provider Registry)**

## Resource Profile: Practitioner Profile (Provider Registry) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner-registry | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:PractitionerProfileRegistry |

 
Proposed constraints and extensions on the Practitioner Resource for use by Provider Registry systems 

# CA Baseline Practitioner Profile for Registries

> While the CA Baseline relies on the existing extensible value set for identifier.type (from the base FHIR Spec) - some Canadian Jurisdictions have published the values that are extensions on that value set. Review of the[Ontario Provider Registry Identifier.Type ValueSet](https://simplifier.net/provincialproviderregistry-ontario-r4/ppr-organization-identifier-type-duplicate-2).identified that the following Ontario specific identifier type codes may be used from the http://ehealthontario.ca/fhir/CodeSystem/ppr-organization-identifier-type code system: LHIN (Local Health Integration Network), MNI (Master Numbering Index), LSS (Lab Services Licensing System, CNUM (Corporate Number), BNUM (Business Number), AC (Accreditation Number).

The CA Baseline is asking other jurisdictions or implementers to provide feedback if other values are being used for identifier.type not already discussed in this profileFor Practitioner.qualification, slicing has been maintained to demonstrate that there are some registries supporting hybridized registry/eReferral use cases that utilize a different code system (HealthcareProviderRoleType) from the QualifiedRoleType that was incorporated by many HL7 V3 implementations. This separation based on use case and age of implementation remains a challenge in the Canadian ecosystem, and has persisted in part due to the challenges some registry assets face in consuming the longer character lengths present in the SNOMED CT CA HealthcareProviderRoleType value set. Until practices are more standardized or a resolution is in place regarding the disparate use of these two code systems, implementers are cautioned that the CA Baseline's use of these code systems and value sets still may change.

The CA Baseline is asking implementers to provide feedback on the value sets and code systems they are expecting to utilize as they transition to FHIR .
Feedback can be provided through the[Simplifier issue log for this profile](https://simplifier.net/CanadianFHIRBaselineProfilesCA-Core/ObservationProfileLaboratory/~issues).

This Practitioner profile sets minimum expectations for the Practitioner resource to record, search and fetch demographics and other administrative information about a person who is directly or indirectly involved in the provisioning of healthcare.

This profile further constrains the general purpose Practitioner profile and is intended to be used by Provider or Healthcare Directory systems.

## Differences from US Core

**Note:** This profile was generated from [HL7 StructureDefinition](https://www.hl7.org/fhir/practitioner.profile.json) on 2020-02-19 and constrained during a review of US Core against Canadian sources.

## Mandatory Data Elements

All elements or attributes defined in FHIR have cardinality as part of their definition - a minimum number of required appearances and a maximum number.

Most elements in FHIR specification have a minimum cardinality of 0, which means that they may be missing from a resource when it is exchanged between systems.

**Required elements:**

* a identifier
* a practitioner name

In addition to that, some optional elements (e.g., **Practitioner.qualification**) have required components that MUST be present if that optional element is provided.

### Data Absent Reason

In situations where the minimum cardinality of an element or attribute is 1 and information is missing and the Responder knows the precise reason for the absence of data, Responders SHALL send the reason for the missing information using values (such as [NullFlavor](https://www.hl7.org/fhir/extension-iso21090-nullflavor.html)) from the value set where they exist or using the [DataAbsentReason](http://hl7.org/fhir/StructureDefinition/data-absent-reason) extension.

## Must Support Data Elements

Some elements are labeled as MustSupport meaning that implementations that produce or consume resources SHALL provide "support" for the element in some meaningful way (see [Must Support](https://build.fhir.org/ig/HL7-Canada/ca-baseline/general-guidance.html#must-support) definition).

Following elements are marked as Must Support in the Practitioner profile to aid record matching in databases with many pediatric records.

**Must Support elements:**

* an identifier
* a practitioner name
* contact detail (e.g. a telephone number or an email address)
* a birth date

## Extensions

### Deceased Extension

This Practitioner profile contains optional [deceased extension](http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-deceased) to indicate if a practitioner is deceased or not.

This extension was previously labeled as a modifier extension (because of its potential impacts on clinical processes if the practitioner is marked deceased), but was removed after further discussion on the nuances of making something a modifierExtension vs regular extension if it was expected to be picked up by registry implementation guides that collect deceased practitioner information but may or may not use it in ways that would align to HL7 FHIR R4 [definition](https://www.hl7.org/fhir/R4/backboneelement-definitions.html#BackboneElement.modifierExtension) and expectations for modifierExtension.

Implementers should recognize that the determination of whether this should be considered a modifierExtension is ongoing. Since Modifier Extensions should have extreme caution in their application and are further nuanced by the use cases in the implementing registry systems, this extension has been shifted back to a regular extension to align to use in existing implementations. Implementers who are considering using this extension in their guidance might consider applying a Must Support flag on the extension, but those treating wanting to re-create it as a modifier extension are required to review the [FHIR Guidance on Modifier Extensions])(https://www.hl7.org/fhir/R4/extensibility.html#modifierExtension) before including this extension in their profile. Implementers should also be aware of the Practitioner.deceased[x] R5 concept and that the CA Baseline is monitoring changes in the element to determine if the approach to this extension requires a shift.

## Usage Note

This Practitioner profile is intended to provide a foundation for a central or distributed Provider or Healthcare Directory. Additional work flow components and elements may be required for a particular implementation.

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-practitioner-registry)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-practitioner-registry.csv), [Excel](StructureDefinition-profile-practitioner-registry.xlsx), [Schematron](StructureDefinition-profile-practitioner-registry.sch) 

### Notes:

## Identifiers

Multiple types of provider identifiers may be used in Practitioner.identifier element in the Canadian context:

* Provincial health plan provider/ Billing number
* Licence Number
* Medical Doctor Number

Implementers may use other identifiers to capture in a more specific way such as internal provider number, jurisdictions providing credentials. The full list of possible identifier types is in [Canadian URI Registry](https://simplifier.net/canadianuriregistry/~resources?category=NamingSystem)

In some cases, the same license number can be used as the provider identifier and provider's qualification identifier.

## Telecom

A provider may have multiple ways to be contacted with different uses or applicable periods. This Practitioner profile allows multiple contact points (e.g. a telephone number or an email address) by which the individual may be contacted.

To indicate the preferred way to contact use Practitioner.telecom.rank attribute (i.e., the [ContactPoint.rank](https://www.hl7.org/fhir/datatypes.html#contactpoint) component) that specifies a preferred order in which to use a set of contacts. ContactPoints with lower rank values are more preferred than those with higher rank values.

## Address

The Practitioner profile is provided for use in a Canadian context where some constraint on content is desirable to guarantee the quality of the Canadian address whilst still supporting other type of address (e.g., other countries or UNstructured addresses).

### Canadian postal code

If an address in the Practitioner resource instance represents Canadian address, it SHOULD follow Canadian postal code format.

The Canadian Postal Code SHOULD be a six-character uniformly structured uppercase alphanumeric code in the form of "ANA NAN", where "A" represents an alphabetic character and "N" represents a numeric character, with one space between the first three and the last three characters.

A hyphen SHOULD NOT be used (example of UNacceptable format: T0L-1K0).

### Preferred

The Practitioner.address MAY have a [Preferred](http://hl7.org/fhir/StructureDefinition/iso21090-preferred) extension. This is the FHIR standard defined extension used as a flag denoting whether parent address item is preferred.

### Qualifications & Credentials

In Canadian context qualifications and credentials are not synonymous. This difference is defined by slices applied to **Practitioner.qualification.code.coding** element.

Qualification defines a code for the degree or educational rank that the credential specifies and may also apply to an expertise type. This profile recommends to use Canadian [QualifiedRoleType](https://tgateway.infoway-inforoute.ca/singlesubset.html?id=2.16.840.1.113883.2.20.3.48) value set as the coded representation of the provider's qualification.

Credential defines a role type that is used to categorize an entity that delivers health care in an expected and professional manner to an entity in need of health care services. It uses Canadian [HealthcareProviderRoleType](https://tgateway.infoway-inforoute.ca/singlesubset.html?id=2.16.840.1.113883.2.20.3.48&versionid=20190813) value set as the coded representation of the provider's credentials.

The binding strength for the Practitioner.qualification.code element is [Preferred](https://www.hl7.org/fhir/terminologies.html#preferred) meaning that implementers are encouraged to draw codes from the specified code system for interoperability purposes but are not required to do so to be considered conformant.

Example:

```
"code": {
  "coding": [
    {
      "system": "https://fhir.infoway-inforoute.ca/CodeSystem/scpqual",
      "code": "BSC",
      "display": "Bachelor of Science Degree"
    }
  ],
  "text": "Bachelor of Science Degree"
}

```



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-practitioner-registry",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner-registry",
  "version" : "1.2.0",
  "name" : "PractitionerProfileRegistry",
  "title" : "Practitioner Profile (Provider Registry)",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the Practitioner Resource for use by Provider Registry systems",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner",
        "short" : "Practitioner Profile",
        "definition" : "The Practitioner Profile is based upon the CA Baseline FHIR Practitioner Profile for general use"
      },
      {
        "id" : "Practitioner.extension",
        "path" : "Practitioner.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Practitioner.extension:deceased",
        "path" : "Practitioner.extension",
        "sliceName" : "deceased",
        "short" : "Indicates if the individual is deceased or not.",
        "definition" : "The fact that a practitioner is deceased influences the clinical process. Also, in human communication and relation management it is necessary to know whether the person is alive.",
        "comment" : "Implementers should recognize that the determination of whether this should be considered a modifierExtension is ongoing. Since Modifier Extensions should have extreme caution in their application and are further nuanced by the use cases in the implementing registry systems, this extension has been shifted back to a regular extension to align to use in existing implementations. Implementers who are considering using this extension in their guidance are required to review the [FHIR Guidance on Modifier Extensions])(https://www.hl7.org/fhir/R4/extensibility.html#modifierExtension) before including this extension in their profile. Implementers should also be aware of the Practitioner.deceased[x] R5 concept and that the CA Baseline is monitoring changes in the element to determine if the approach to this extension requires a shift.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-deceased"
            ]
          }
        ]
      },
      {
        "id" : "Practitioner.identifier",
        "path" : "Practitioner.identifier",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-identifier"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name",
        "path" : "Practitioner.name",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.telecom",
        "path" : "Practitioner.telecom",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.address.extension",
        "path" : "Practitioner.address.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Practitioner.address.extension:preferred",
        "path" : "Practitioner.address.extension",
        "sliceName" : "preferred",
        "short" : "HL7 Preferred Address Flag extension",
        "definition" : "Flag denoting whether parent address item is preferred",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/iso21090-preferred"]
          }
        ]
      },
      {
        "id" : "Practitioner.birthDate",
        "path" : "Practitioner.birthDate",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.qualification",
        "path" : "Practitioner.qualification",
        "comment" : "Slicing has been maintained to demonstrate that there are some registries supporting hybridized registry/eReferral use cases that require a separate set of codes. Until practices are more standardized regarding these two code systems, implementers are cautioned that these code systems and value sets still may change. Implementers are encouraged to provide feedback on the value sets and code systems they are expecting to utilize."
      },
      {
        "id" : "Practitioner.qualification.code.coding",
        "path" : "Practitioner.qualification.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "system"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Practitioner.qualification.code.coding.system",
        "path" : "Practitioner.qualification.code.coding.system",
        "min" : 1
      },
      {
        "id" : "Practitioner.qualification.code.coding.code",
        "path" : "Practitioner.qualification.code.coding.code",
        "min" : 1
      },
      {
        "id" : "Practitioner.qualification.code.coding:Registry",
        "path" : "Practitioner.qualification.code.coding",
        "sliceName" : "Registry"
      },
      {
        "id" : "Practitioner.qualification.code.coding:Registry.system",
        "path" : "Practitioner.qualification.code.coding.system",
        "short" : "QualifiedRoleType",
        "definition" : "A code system for the degree or educational rank that the credential specifies. May also apply to an Expertise type.",
        "min" : 1,
        "fixedUri" : "https://fhir.infoway-inforoute.ca/CodeSystem/scpqual"
      },
      {
        "id" : "Practitioner.qualification.code.coding:eReferral",
        "path" : "Practitioner.qualification.code.coding",
        "sliceName" : "eReferral",
        "comment" : "Some registries may be used to support electronic referral use cases. A separate code system for practitioner qualification codes has been identified as in use by at least one Canadian regsitry supporting the hybridized use case."
      },
      {
        "id" : "Practitioner.qualification.code.coding:eReferral.system",
        "path" : "Practitioner.qualification.code.coding.system",
        "short" : "HealthcareProviderRoleType",
        "definition" : "A role type that is used to categorize an entity that delivers health care in an expected and professional manner to an entity in need of health care services.",
        "min" : 1,
        "fixedUri" : "https://fhir.infoway-inforoute.ca/CodeSystem/scptype"
      }
    ]
  }
}

```
