# Organization Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Organization Profile**

## Resource Profile: Organization Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:OrganizationProfile |

 
Proposed constraints and extensions on the Organization resource 

# CA Baseline Organization Profile

This Organization profile sets minimum expectations for the Organization resource to record, search and fetch a formally or informally recognized grouping of people or organizations formed for the purpose of achieving some form of collective action.

This profile defines localization concepts for use in a Canadian context.

## Mandatory Data Elements

All elements or attributes defined in FHIR have cardinality as part of their definition - a minimum number of required appearances and a maximum number.

Most elements in FHIR specification have a minimum cardinality of 0, which means that they may be missing from a resource when it is exchanged between systems.

In this Canadian Baseline Organization Profile all elements are optional, i.e., there is no element with a minimum cardinality of 1. However, some optional elements (e.g., identifier) have required components that MUST be present if that optional element is provided.

## Must Support Data Elements

Some elements are labeled as MustSupport meaning that implementations that produce or consume resources SHALL provide "support" for the element in some meaningful way (see [Must Support](https://build.fhir.org/ig/HL7-Canada/ca-baseline/general-guidance.html#must-support) definition).

Following elements are marked as Must Support in the Canadian Organization profile to aid record matching in databases with many pediatric records.

**Must Support elements:**

* an identifier
* an organization name
* contact detail (e.g. a telephone number or an email address)

**Usages:**

* Refer to this Profile: [DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-profile-diagnosticreport.md), [Diagnostic Report for Report and Note Exchange Profile](StructureDefinition-profile-diagnosticreportnote.md), [DocumentReference Profile for metadata about the document](StructureDefinition-profile-documentreference.md), [Encounter Profile](StructureDefinition-profile-encounter.md)...Show 10 more,[Immunization Profile](StructureDefinition-profile-immunization.md),[ImmunizationRecommendation Profile](StructureDefinition-profile-immunizationrecommendation.md),[Medication Profile](StructureDefinition-profile-medication.md),[MedicationDispense Profile](StructureDefinition-profile-medicationdispense.md),[MedicationRequest Profile](StructureDefinition-profile-medicationrequest.md),[MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md),[Observation Profile (Laboratory Results)](StructureDefinition-profile-observation-results.md),[OrganizationAffiliation Profile](StructureDefinition-profile-organizationaffiliation.md),[Procedure Profile](StructureDefinition-profile-procedure.md)and[ServiceRequest Profile for Results Reporting](StructureDefinition-profile-servicerequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-organization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-organization.csv), [Excel](StructureDefinition-profile-organization.xlsx), [Schematron](StructureDefinition-profile-organization.sch) 

### Notes:

## Identifiers

Currently, there is no consensus or requirement for pan-Canadian method to identify an organization using a business identifier. Organization.identifier will remain unsliced until a requirement or rationale is put forth that supports the need to have unique constraints determined by the business identifier.

## Service Language

The Organization MAY have a [Service Language](http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-servicelanguage) extension. This extension is to identify languages that that services are provided in this particular organization.

## Address

The Organization profile is provided for use in a Canadian context where some constraint on content is desirable to guarantee the quality of the Canadian address whilst still supporting other type of address (e.g., other countries or UNstructured addresses).

### Canadian postal code

If an address in the Organization resource instance represents Canadian address, it SHOULD follow Canadian postal code format.

The Canadian Postal Code SHOULD be a six-character uniformly structured uppercase alphanumeric code in the form of "ANA NAN", where "A" represents an alphabetic character and "N" represents a numeric character, with one space between the first three and the last three characters.

A hyphen SHOULD NOT be used (example of UNacceptable format: T0L-1K0).

### Preferred

The Organization.address MAY have a [Preferred](http://hl7.org/fhir/StructureDefinition/iso21090-preferred) extension. This is the FHIR standard defined extension used as a flag denoting whether parent address item is preferred.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-organization",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization",
  "version" : "1.2.0",
  "name" : "OrganizationProfile",
  "title" : "Organization Profile",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the Organization resource",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.extension:communication",
        "path" : "Organization.extension",
        "sliceName" : "communication",
        "short" : "Languages used to provide services",
        "definition" : "Indentifies languages that services are provided in at the organization.",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-servicelanguage"
            ]
          }
        ],
        "mustSupport" : false,
        "isModifier" : false
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "mustSupport" : true
      },
      {
        "id" : "Organization.address",
        "path" : "Organization.address"
      },
      {
        "id" : "Organization.address.extension",
        "path" : "Organization.address.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Organization.address.extension:preferred",
        "path" : "Organization.address.extension",
        "sliceName" : "preferred",
        "short" : "HL7 Preferred Address Flag extension",
        "definition" : "Flag denoting whether parent address item is preferred",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/iso21090-preferred"]
          }
        ]
      }
    ]
  }
}

```
