# Observation Profile (General) - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Observation Profile (General)**

## Resource Profile: Observation Profile (General) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:ObservationProfile |

 
Proposed constraints on the Observation Resource for general use. This profile sets minimum expectations for the Observation resource to represent various observations if no other, more specific profile is applicable. An observation is a measurement or assertion about a subject (person, group, device, location, or another subject). 

# CA Baseline Observation (General Use) Profile

> While this profile does not currently apply MS constraints on the hasMember or component elements, this profile is seeking community and implementer feedback on how both elements are being used to assess whether consistent patterns can be identified for use in the Canadian landscape.
Feedback can be provided through the[Simplifier issue log for this profile](https://simplifier.net/CanadianFHIRBaselineProfilesCA-Core/ObservationProfileLaboratory/~issues).

This profile sets minimum expectations for the Observation resource to represent various observations if no other, more specific profile is applicable. An observation is a measurement or assertion about a subject (person, group, device, location, or another subject).

This profile defines localization concepts for use in the Canadian context.

## Mandatory Data Elements

All elements or attributes within the FHIR specification have cardinality as part of their definition - a minimum number of required appearances and a maximum number of allowable appearances.

Most elements in the FHIR specification have a minimum cardinality of 0, so most elements are not required and subsequently they may be missing from a resource when it is exchanged between systems.

**Required elements in the Observation (General Use) profile:**

* status of the result value (Observation.status)
* type of observation (Observation.code)
* subject of the observation (Observation.subject)

## Must Support Data Elements

Some elements are marked as Must Support. This means that implementations generating, receiving, or otherwise using resources with Must Support elements SHALL provide support for those elements in some meaningful way (see Must Support definition).

The following elements are marked as Must Support in the Observation (General Use) profile:

**Must Support elements:**

* category
* code
* reference to a subject (Observation.subject)
* effective data
* value
* component code (if implementer supports component)
* component value (if implementer supports component)

## Usage Note

Observation (General Use) is intended to capture data associated with most observations; it is not intended to capture data in some cases where a more appropriate profile is applicable (see below). Data typically consists of measurements or assertions about a subject. Observation (General Use) can capture data in eclectic use cases as it incorporates multiple categories of observations and datatypes. Observation (General Use) can capture data such as:

* Clinical observations such as clinical finding, diagnosis, disorder
* Demographic information
* Device measurements
* Determinants of health such as housing status, income, family support

Observation (General Use) should not be used if one of the following profiles is applicable:

* Observation (Laboratory Results)
* Observation (Vitals)

**Usages:**

* Derived from this Profile: [Observation Profile (Laboratory Results)](StructureDefinition-profile-observation-results.md)
* Refer to this Profile: [DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-profile-diagnosticreport.md), [Encounter Profile](StructureDefinition-profile-encounter.md), [Immunization Profile](StructureDefinition-profile-immunization.md), [MedicationAdministration Profile](StructureDefinition-profile-medicationadministration.md)...Show 4 more,[MedicationRequest Profile](StructureDefinition-profile-medicationrequest.md),[MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md),[Procedure Profile](StructureDefinition-profile-procedure.md)and[ServiceRequest Profile for Results Reporting](StructureDefinition-profile-servicerequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-observation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-observation.csv), [Excel](StructureDefinition-profile-observation.xlsx), [Schematron](StructureDefinition-profile-observation.sch) 

### Notes:

## Using codes in Observation

Additional codes that translate or map to the Observation code or category codes are allowed (see [CodeableConcept](http://hl7.org/fhir/R4/datatypes.html#CodeableConcept) data type).

Examples:

* providing both a local code and LOINC code
* providing more specific category codes
* providing a SNOMED CT concept
* providing system specific codes

## Category

The **Observation.category** specifies a code that classifies the type of observation. The **Observation.category** element is a [CodeableConcept](http://hl7.org/fhir/R4/datatypes.html#CodeableConcept) data type, and more than one code is allowed.

For interoperability reasons, one of the codes SHOULD be from the FHIR standard defined [Observation Category Codes](https://www.hl7.org/fhir/valueset-observation-category.html).

Local codes are allowed as well. In the case of using local codes, in order to classify the type of observation both **category.coding.system** and **category.coding.code** SHOULD be provided.

## Code

The **Observation.code** element describes what was observed. Sometimes this is called the observation "name".

The [pan-Canadian LOINC Observation Code Database (pCLOCD)](https://infocentral.infoway-inforoute.ca/en/standards/canadian/pclocd-loinc) is recommended for use in the Canadian context. pCLOCD Code System URI is https://fhir.infoway-inforoute.ca/CodeSystem/pCLOCD

## value[x] and dataAbsentReason

Observation (General Use) uses a name-value pair to code data. When the value for the actual observation is not known, i.e., the value for **Observation.value[x]** is not available, then **Observation.value[x]** will not be present and the **Observation.dataAbsentReason** SHALL be present and will provide a reason why the expected value is missing. Also, the **Observation.dataAbsentReason** SHALL only be present if and only if the value for **Observation.value[x]** is not present.

The same rule applies when **Observation.component** is used. I.e., if **Observation.component.value[x]** is missed, then **Observation.component.dataAbsentReason** SHALL be present with the reason.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-observation",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation",
  "version" : "1.2.0",
  "name" : "ObservationProfile",
  "title" : "Observation Profile (General Use)",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints on the Observation Resource for general use. This profile sets minimum expectations for the Observation resource to represent various observations if no other, more specific profile is applicable. An observation is a measurement or assertion about a subject (person, group, device, location, or another subject).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Observation Profile",
        "definition" : "The Observation Profile is based upon the core FHIR Observation Resource"
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status"
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "mustSupport" : true
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "comment" : "The binding strength of this element is [Preferred](https://www.hl7.org/fhir/terminologies.html#strength), meaning that codes are encouraged to draw from the LOINC code system for interoperability purposes but are not required to do so to be considered conformant. *All* code-value and, if present, component.code-component.value pairs need to be taken into account to correctly understand the meaning of the observation.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "description" : "LOINC codes identifying names of simple observations.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-codes"
        }
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.org/fhir/StructureDefinition/Location"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "type" : [
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "Observation.dataAbsentReason",
        "path" : "Observation.dataAbsentReason",
        "comment" : "This element is recommended for support and was initially flagged as must support but was later determined to be too strong for some types of observation profiles that want to derive from the CA Baseline but do not need a dataAbsentReason concept"
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "comment" : "Some elements underneath this backbone element are considered must support. This does not incur the expectation to support these elements for any implementers that do not need to support the parent concept of observation.component. This may need to be evaluated in the future as impelementations seek to derive directly from the CA Baseline profiles"
      },
      {
        "id" : "Observation.component.code",
        "path" : "Observation.component.code",
        "comment" : "The binding strength of this element is [Preferred](https://www.hl7.org/fhir/terminologies.html#strength), meaning that codes are encouraged to draw from the LOINC code system for interoperability purposes but are not required to do so to be considered conformant. *All* code-value and, if present, component.code-component.value pairs need to be taken into account to correctly understand the meaning of the observation.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "description" : "LOINC codes identifying names of simple observations.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-codes"
        }
      },
      {
        "id" : "Observation.component.value[x]",
        "path" : "Observation.component.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component.dataAbsentReason",
        "path" : "Observation.component.dataAbsentReason"
      }
    ]
  }
}

```
