# MedicationRequest Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **MedicationRequest Profile**

## Resource Profile: MedicationRequest Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationrequest | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:MedicationRequestProfile |

 
Proposed constraints and extensions on the MedicationRequest resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. 

This profile was generated from [HL7 StructureDefinition](https://www.hl7.org/fhir/medicationrequest.profile.json) on 2019-03-28 and constrained during a review of US Core against Canadian sources.

Key differences from [USCoreR4 MedicationRequest](https://build.fhir.org/ig/HL7/US-Core-R4/StructureDefinition-us-core-medicationrequest.html):

* MedicationRequest.medication updated: 
* CodeableConcept binding to ValueSet-prescriptionmedicinalproduct
* Reference to profile-medication
 
* MedicationRequest.subject reference updated to profile-patient
* MedicationRequest.requester reference updated to profile-practitioner

**Usages:**

* Refer to this Profile: [MedicationAdministration Profile](StructureDefinition-profile-medicationadministration.md), [MedicationDispense Profile](StructureDefinition-profile-medicationdispense.md), [MedicationRequest Profile](StructureDefinition-profile-medicationrequest.md), [MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md) and [ServiceRequest Profile for Results Reporting](StructureDefinition-profile-servicerequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-medicationrequest)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-medicationrequest.csv), [Excel](StructureDefinition-profile-medicationrequest.xlsx), [Schematron](StructureDefinition-profile-medicationrequest.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-medicationrequest",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationrequest",
  "version" : "1.2.0",
  "name" : "MedicationRequestProfile",
  "title" : "MedicationRequest Profile",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the MedicationRequest resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest",
        "path" : "MedicationRequest",
        "short" : "MedicationRequest Profile",
        "definition" : "The Canadian Baseline MedicationRequest Profile is based upon the core FHIR MedicationRequest Resource"
      },
      {
        "id" : "MedicationRequest.status",
        "path" : "MedicationRequest.status",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.reported[x]",
        "path" : "MedicationRequest.reported[x]",
        "type" : [
          {
            "code" : "boolean"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.medication[x]",
        "path" : "MedicationRequest.medication[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medication"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "description" : "TBD. This is a placeholder for a comprehensive valueset, consisting of all Manufactured Product (MP), Non-proprietary Therapeutic Product (NTP) and Therapeutic Moiety (TM) codes, which would be created and maintained by Canada Health Infoway. Medicinal products for prescribing and dispensing in Canada. The content of this subset only contains commonly used medicinal products that are available for prescribing and dispensing in Canada. This content will expand to include all human medicinal products over time.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/prescriptionmedicinalproduct"
        }
      },
      {
        "id" : "MedicationRequest.subject",
        "path" : "MedicationRequest.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.encounter",
        "path" : "MedicationRequest.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-encounter"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.authoredOn",
        "path" : "MedicationRequest.authoredOn",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.requester",
        "path" : "MedicationRequest.requester",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.performer",
        "path" : "MedicationRequest.performer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
              "http://hl7.org/fhir/StructureDefinition/CareTeam"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.recorder",
        "path" : "MedicationRequest.recorder",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.reasonReference",
        "path" : "MedicationRequest.reasonReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-condition",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.basedOn",
        "path" : "MedicationRequest.basedOn",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/CarePlan",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationrequest",
              "http://hl7.org/fhir/StructureDefinition/ServiceRequest",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-immunizationrecommendation"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.dosageInstruction",
        "path" : "MedicationRequest.dosageInstruction",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.text",
        "path" : "MedicationRequest.dosageInstruction.text",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.performer",
        "path" : "MedicationRequest.dispenseRequest.performer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.priorPrescription",
        "path" : "MedicationRequest.priorPrescription",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationrequest"
            ]
          }
        ]
      }
    ]
  }
}

```
