# MedicationDispense Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **MedicationDispense Profile**

## Resource Profile: MedicationDispense Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationdispense | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:MedicationDispenseProfile |

 
Proposed constraints and extensions on the MedicationDispense resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. 

# CA Baseline MedicationDispense Profile

This profile sets minimum expectations for the MedicationDispense resource. This profile defines localization concepts for use in the Canadian context.

## Mandatory Data Elements

All elements or attributes within the FHIR specification have cardinality as part of their definition - a minimum number of required appearances and a maximum number of allowable appearances.

Most elements in the FHIR specification have a minimum cardinality of 0, so most elements are not required and subsequently they may be missing from a resource when it is exchanged between systems.

**Required elements in the Observation (General Use) profile:**

* status (required in the base specification)
* medication (required in the base specification)
* subject

## Must Support Data Elements

The following elements are marked as Must Support in this profile:

**Must Support elements:**

* status
* medication
* subject
* quantity
* whenPrepared
* dosageInstruction

## CA Core Considerations

The whenHandedOver element was initially profiled as must support and was later relaxed through the Due Diligence Review Process with the goal of not constraining for certain use cases over others. Given the criticality to many clinical/pharmaceutical use cases, it has been identified as an element to consider for additional constraints in the CA Core Profiles which are to be developed in the future under the guidance of a larger collaborative of pan-Canadian governing bodies.

**Usages:**

* Refer to this Profile: [MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-medicationdispense)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-medicationdispense.csv), [Excel](StructureDefinition-profile-medicationdispense.xlsx), [Schematron](StructureDefinition-profile-medicationdispense.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-medicationdispense",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationdispense",
  "version" : "1.2.0",
  "name" : "MedicationDispenseProfile",
  "title" : "MedicationDispense Profile",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the MedicationDispense resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rx-dispense-rmim",
      "uri" : "http://www.hl7.org/v3/PORX_RM020070UV",
      "name" : "V3 Pharmacy Dispense RMIM"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationDispense",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationDispense",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationDispense",
        "path" : "MedicationDispense",
        "short" : "MedicationDispense Profile",
        "definition" : "The Canadian Baseline MedicationDispense Profile is based upon the core FHIR MedicationDispense Resource"
      },
      {
        "id" : "MedicationDispense.extension",
        "path" : "MedicationDispense.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "MedicationDispense.extension:renderedDosageInstruction",
        "path" : "MedicationDispense.extension",
        "sliceName" : "renderedDosageInstruction",
        "short" : "Socialized Optional Extension: PrescribeIT renderedDosageInstruction",
        "definition" : "Provides a complete text rendering of dosageInstruction lines for an order or dispense (separate from the rendering of the overall resource instance)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://prescribeit.ca/fhir/StructureDefinition/ext-medication-rendered-dosage"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.extension:quantityRemaining",
        "path" : "MedicationDispense.extension",
        "sliceName" : "quantityRemaining",
        "short" : "Socialized Optional Extension: PrescribeIT quantityRemaining",
        "definition" : "The total authorized quantity outstanding after the fill issued as part of this dispense record",
        "comment" : "In R5, an equivalent extension is put forth in the base FHIR specification - R5 implementors are encouraged to review: http://hl7.org/fhir/StructureDefinition/medicationdispense-quantityRemaining",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://prescribeit.ca/fhir/StructureDefinition/ext-dispense-quantity-remaining"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.partOf",
        "path" : "MedicationDispense.partOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-procedure"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.status",
        "path" : "MedicationDispense.status",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.medication[x]",
        "path" : "MedicationDispense.medication[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medication"
            ]
          }
        ],
        "example" : [
          {
            "label" : "DIN",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://fhir.infoway-inforoute.ca/ValueSet/CA-HC-DIN"
                }
              ]
            }
          },
          {
            "label" : "NPN",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://fhir.infoway-inforoute.ca/ValueSet/CA-HC-NPN"
                }
              ]
            }
          },
          {
            "label" : "CCDD",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://fhir.infoway-inforoute.ca/ValueSet/prescriptionmedicinalproduct"
                }
              ]
            }
          },
          {
            "label" : "SNOMED CT (Medications) - IPS",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/ips/ValueSet/medication-snomed-uv-ips"
                }
              ]
            }
          },
          {
            "label" : "WHO ATC IPS",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/uv/ips/ValueSet/whoatc-uv-ips"
                }
              ]
            }
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "description" : "TBD. This is a placeholder for a comprehensive valueset, consisting of all Manufactured Product (MP), Non-proprietary Therapeutic Product (NTP) and Therapeutic Moiety (TM) codes, which would be created and maintained by Canada Health Infoway. Medicinal products for prescribing and dispensing in Canada. The content of this subset only contains commonly used medicinal products that are available for prescribing and dispensing in Canada. This content will expand to include all human medicinal products over time.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/prescriptionmedicinalproduct"
        }
      },
      {
        "id" : "MedicationDispense.subject",
        "path" : "MedicationDispense.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.context",
        "path" : "MedicationDispense.context",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-encounter",
              "http://hl7.org/fhir/StructureDefinition/EpisodeOfCare"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.performer.actor",
        "path" : "MedicationDispense.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.location",
        "path" : "MedicationDispense.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-location"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.authorizingPrescription",
        "path" : "MedicationDispense.authorizingPrescription",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationrequest"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.quantity",
        "path" : "MedicationDispense.quantity",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.whenPrepared",
        "path" : "MedicationDispense.whenPrepared",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.destination",
        "path" : "MedicationDispense.destination",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-location"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.receiver",
        "path" : "MedicationDispense.receiver",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.dosageInstruction",
        "path" : "MedicationDispense.dosageInstruction",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.extension",
        "path" : "MedicationDispense.dosageInstruction.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "MedicationDispense.dosageInstruction.extension:instructionRelationship",
        "path" : "MedicationDispense.dosageInstruction.extension",
        "sliceName" : "instructionRelationship",
        "short" : "Socialized Optional Extension: PrescribeIT dosageInstruction Relationship",
        "definition" : "Indicates how the timing of this dosage instruction relates to the preceding dosage instruction. Specifically, is it concurrent (AND) or sequential (THEN).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://prescribeit.ca/fhir/StructureDefinition/ext-medicationorder-dosageinstruction-relationship"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.dosageInstruction.text",
        "path" : "MedicationDispense.dosageInstruction.text",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.substitution.responsibleParty",
        "path" : "MedicationDispense.substitution.responsibleParty",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole"
            ]
          }
        ]
      }
    ]
  }
}

```
