# ImmunizationRecommendation Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **ImmunizationRecommendation Profile**

## Resource Profile: ImmunizationRecommendation Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-immunizationrecommendation | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:ImmunizationRecommendationProfile |

 
Proposed constraints and extensions on the ImmunizationRecommendation resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. 

# CA Baseline ImmunizationRecommendation Profile

**Usages:**

* Refer to this Profile: [Encounter Profile](StructureDefinition-profile-encounter.md) and [MedicationRequest Profile](StructureDefinition-profile-medicationrequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-immunizationrecommendation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-immunizationrecommendation.csv), [Excel](StructureDefinition-profile-immunizationrecommendation.xlsx), [Schematron](StructureDefinition-profile-immunizationrecommendation.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-immunizationrecommendation",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-immunizationrecommendation",
  "version" : "1.2.0",
  "name" : "ImmunizationRecommendationProfile",
  "title" : "ImmunizationRecommendation Profile",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the ImmunizationRecommendation resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ImmunizationRecommendation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ImmunizationRecommendation",
        "path" : "ImmunizationRecommendation",
        "short" : "ImmunizationRecommendation Profile",
        "definition" : "The ImmunizationRecommendation Profile is based upon the core FHIR ImmunizationRecommendation Resource"
      },
      {
        "id" : "ImmunizationRecommendation.patient",
        "path" : "ImmunizationRecommendation.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ImmunizationRecommendation.date",
        "path" : "ImmunizationRecommendation.date",
        "mustSupport" : true
      },
      {
        "id" : "ImmunizationRecommendation.authority",
        "path" : "ImmunizationRecommendation.authority",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "ImmunizationRecommendation.recommendation",
        "path" : "ImmunizationRecommendation.recommendation",
        "mustSupport" : true
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.vaccineCode",
        "path" : "ImmunizationRecommendation.recommendation.vaccineCode",
        "comment" : "CA Core Usage Notes: the assumption is that ImmunizationRecommendation (forecast) is always on the level of a generic vaccine code and/or target disease. TBD: to confirm that there is no use case when an ImmunizationRecommendation needs to be on the vaccine tradename level (e.g. there is no sitation when a 2nd dose has to be of the same tradename as the 1st dose).",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://cvc.canimmunize.ca/v3/ValueSet/Generic"
        }
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.vaccineCode.coding",
        "path" : "ImmunizationRecommendation.recommendation.vaccineCode.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "system"
            },
            {
              "type" : "pattern",
              "path" : "code"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.vaccineCode.coding:Generic",
        "path" : "ImmunizationRecommendation.recommendation.vaccineCode.coding",
        "sliceName" : "Generic",
        "comment" : "CA Baseline Usage Notes: either a Generic code or a Tradename code or both have to be present.",
        "max" : "1",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://cvc.canimmunize.ca/v3/ValueSet/Generic"
        }
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.vaccineCode.coding:Tradename",
        "path" : "ImmunizationRecommendation.recommendation.vaccineCode.coding",
        "sliceName" : "Tradename",
        "comment" : "CA Baseline Usage Notes: either a Generic code or a Tradename code or both have to be present.",
        "max" : "1",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://cvc.canimmunize.ca/v3/ValueSet/Tradename"
        }
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.targetDisease",
        "path" : "ImmunizationRecommendation.recommendation.targetDisease",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://cvc.canimmunize.ca/v3/ValueSet/Disease"
        }
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.forecastStatus",
        "path" : "ImmunizationRecommendation.recommendation.forecastStatus",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://cvc.canimmunize.ca/v3/ValueSet/ForecastStatus"
        }
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.dateCriterion",
        "path" : "ImmunizationRecommendation.recommendation.dateCriterion",
        "mustSupport" : true
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.dateCriterion.code",
        "path" : "ImmunizationRecommendation.recommendation.dateCriterion.code",
        "mustSupport" : true
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.dateCriterion.value",
        "path" : "ImmunizationRecommendation.recommendation.dateCriterion.value",
        "mustSupport" : true
      },
      {
        "id" : "ImmunizationRecommendation.recommendation.supportingImmunization",
        "path" : "ImmunizationRecommendation.recommendation.supportingImmunization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-immunization",
              "http://hl7.org/fhir/StructureDefinition/ImmunizationEvaluation"
            ]
          }
        ]
      }
    ]
  }
}

```
