# Identifier DataType Profile (CA Baseline) - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Identifier DataType Profile (CA Baseline)**

## Data Type Profile: Identifier DataType Profile (CA Baseline) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-identifier | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:IdentifierCABaseline |

 
This profile constrains the identifier data type to support minimum expectations of Canadian systems when expressing the identifier data type. 

**Usages:**

* Use this DataType Profile: [Patient Profile](StructureDefinition-profile-patient.md), [Practitioner Profile (Provider Registry)](StructureDefinition-profile-practitioner-registry.md), [Practitioner Profile (General)](StructureDefinition-profile-practitioner.md), [PractitionerRole Profile (Provider Registry)](StructureDefinition-profile-practitionerrole-registry.md) and [PractitionerRole Profile (General)](StructureDefinition-profile-practitionerrole.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-identifier)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-identifier.csv), [Excel](StructureDefinition-profile-identifier.xlsx), [Schematron](StructureDefinition-profile-identifier.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-identifier",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-identifier",
  "version" : "1.2.0",
  "name" : "IdentifierCABaseline",
  "title" : "Identifier DataType Profile (CA Baseline)",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "This profile constrains the identifier data type to support minimum expectations of Canadian systems when expressing the identifier data type.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Identifier",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Identifier",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Identifier",
        "path" : "Identifier"
      },
      {
        "id" : "Identifier.system",
        "path" : "Identifier.system",
        "min" : 1
      },
      {
        "id" : "Identifier.value",
        "path" : "Identifier.value",
        "min" : 1
      }
    ]
  }
}

```
