# Condition Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Condition Profile**

## Resource Profile: Condition Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-condition | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:ConditionProfile |

 
Proposed constraints and extensions on the Condition Resource 

# CA Baseline Condition Profile

> This profile is seeking community and implementer feedback on whether further constraints on use of verificationStatus are needed.

VerificationStatus has been identified by members of our community as having clinical significance, though standardization around its use is still evolving in the international community (particularly in implementation guidance and value sets). We are currently seeking feedback from implementers on current utilization practices before further strengthening guidance on its use.
Feedback can be provided through the[Simplifier issue log for this profile.](https://simplifier.net/CanadianFHIRBaselineProfilesCA-Core/PatientProfile/~issues). Proposed language for inclusion under our Best Practice/Should support section is also welcomed.

This profile constrains the Condition resource to record a list of problems associated with a patient. It identifies which elements, vocabularies and value sets to be present in the resource when using this profile.

This profile defines localization concepts for use in a Canadian context.

## Mandatory Data Elements

All elements or attributes defined in FHIR have cardinality as part of their definition - a minimum number of required appearances and a maximum number.

Most elements in FHIR specification have a minimum cardinality of **0**, which means that they may be missing from a resource when it is exchanged between systems.

**Required elements:**

* code identifying the patient's relevant condition
* reference to a subject

## Must Support Data Elements

Some elements are labeled as MustSupport meaning that implementations that produce or consume resources SHALL provide "support" for the element in some meaningful way (see [Must Support](https://build.fhir.org/ig/HL7-Canada/ca-baseline/general-guidance.html#must-support) definition).

Following elements are marked as Must Support in the Canadian Condition profile to aid record matching in databases with many pediatric records.

**Must Support elements:**

* clinical status of the condition
* code identifying the patient's relevant condition
* reference to subject
* onset - estimated or actual date of the condition

## Usage Note

Condition is intended for capturing and querying patient's current and historical problems.

**Usages:**

* Refer to this Profile: [Encounter Profile](StructureDefinition-profile-encounter.md), [Immunization Profile](StructureDefinition-profile-immunization.md), [MedicationAdministration Profile](StructureDefinition-profile-medicationadministration.md), [MedicationRequest Profile](StructureDefinition-profile-medicationrequest.md)...Show 3 more,[MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md),[Procedure Profile](StructureDefinition-profile-procedure.md)and[ServiceRequest Profile for Results Reporting](StructureDefinition-profile-servicerequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-condition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-condition.csv), [Excel](StructureDefinition-profile-condition.xlsx), [Schematron](StructureDefinition-profile-condition.sch) 

### Notes:

## Clinical Status

Rules derived from the FHIR Condition resource description:

* **Condition.clinicalStatus** SHALL be present if **Condition.verificationStatus** is not entered-in-error and category is problem-list-item.
* **Condition.clinicalStatus** SHALL NOT be present if verification Status is entered-in-error.

Rational: Most systems will expect a clinicalStatus to be valued for problem-list-items that are managed over time, but might not need a clinicalStatus for point in time encounter-diagnosis.

## Verification Status

The verification status supports the clinical status of the condition.

The verification status element is labeled as a modifier because the status contains the code refuted and entered-in-error that mark the Condition as not currently valid.

The **Condition.verificationStatus** is optional considering the use case of using the Condition to populate a problem list where clinically documented problems range from general descriptions (e.g. "short of breath") to specific diagnoses with no verification step.

## Code

The identification of the the client's relevant condition, problem or diagnosis or recording of "problem absent" or of "problems unknown", as interpreted by the provider.

The **Condition.code** element is [CodeableConcept](https://www.hl7.org/fhir/datatypes.html#codeableconcept) data type meaning that more than one [Coding](https://www.hl7.org/fhir/datatypes.html#codesystem) sub-elements can be present. One of these Coding sub-elements SHALL use [Health Concern Code](https://tgateway.infoway-inforoute.ca/vs/healthconcerncode) value set from Canada Health Infoway. Other Coding component are transaltion of the HealthConcernCode to other code systems.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-condition",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-condition",
  "version" : "1.2.0",
  "name" : "ConditionProfile",
  "title" : "Condition Profile",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the Condition Resource",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Condition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition",
        "path" : "Condition",
        "short" : "Condition Profile",
        "definition" : "The Condition Profile is based upon the core FHIR Condition Resource"
      },
      {
        "id" : "Condition.clinicalStatus",
        "path" : "Condition.clinicalStatus",
        "mustSupport" : true,
        "isModifier" : true,
        "isModifierReason" : "This element is labeled as a modifier because the status contains codes that mark the condition as no longer active."
      },
      {
        "id" : "Condition.verificationStatus",
        "path" : "Condition.verificationStatus",
        "comment" : "This profile is seeking community and implementer feedback on whether further constraints on use of verificationStatus are needed. Feedback on current utilization practices is encouraged to support this effort.",
        "isModifier" : true,
        "isModifierReason" : "This element is labeled as a modifier because the status contains the code refuted and entered-in-error that mark the Condition as not currently valid."
      },
      {
        "id" : "Condition.code",
        "path" : "Condition.code",
        "definition" : "Identification of the patient's relevant condition, problem or diagnosis or recording of 'problem absent' or of 'problems unknown', as interpreted by the provider.",
        "comment" : "The larger SNOMED CT CA data exchange value set (ClinicalFinding) has been included as a preferred binding for this element. However, HealthConcernCode (which is a subset of SCTCA) has been maintained as a slice to recognize that the subset is is commonly used by Primary Health Care EMRs and was developed and reinforced through inclusion in CIHI Pan-Canadian Primary Health Care EMR Minimum Data Set",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "description" : "Codes for problems from the SNOMED CT Canadian edition value set",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/clinicalfindingcode"
        }
      },
      {
        "id" : "Condition.code.coding",
        "path" : "Condition.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "binding.valueSet"
            }
          ],
          "rules" : "open"
        },
        "definition" : "Identification of the patient's relevant condition, problem or diagnosis or recording of 'problem absent' or of 'problems unknown', as interpreted by the provider.",
        "mustSupport" : true
      },
      {
        "id" : "Condition.code.coding:HealthConcernCode",
        "path" : "Condition.code.coding",
        "sliceName" : "HealthConcernCode",
        "short" : "CHI identification of the condition, problem or diagnosis",
        "definition" : "The code that represents relevant clinical problems, conditions, diagnoses, symptoms, findings and complaints, as interpreted by the provider shall be taken from [CHI Health Concern Code](https://fhir.infoway-inforoute.ca/ValueSet/healthconcerncode)",
        "comment" : "HealthConcernCode is a subset of the larger SNOMED CT CA data exchange value set (ClinicalFinding) that is preferred binding for the parent element. HealthConcernCode has been maintained as a slice to recognize that the subset is is commonly used by Primary Health Care EMRs and was developed and reinforced through inclusion in CIHI Pan-Canadian Primary Health Care EMR Minimum Data Set",
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "binding" : {
          "strength" : "required",
          "description" : "Represents the patient's relevant clinical problems, conditions, diagnoses, symptoms, findings and complaints, as interpreted by the provider.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/healthconcerncode"
        }
      },
      {
        "id" : "Condition.code.coding:@default",
        "path" : "Condition.code.coding",
        "sliceName" : "@default",
        "short" : "Other identifications of the condition, problem or diagnosis",
        "definition" : "Other identifications of the patient's relevant condition, problem or diagnosis or recording of 'problem absent' or of 'problems unknown', as interpreted by the provider.",
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-code"
        }
      },
      {
        "id" : "Condition.subject",
        "path" : "Condition.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.encounter",
        "path" : "Condition.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-encounter"
            ]
          }
        ]
      },
      {
        "id" : "Condition.onset[x]",
        "path" : "Condition.onset[x]",
        "mustSupport" : true
      },
      {
        "id" : "Condition.recorder",
        "path" : "Condition.recorder",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      },
      {
        "id" : "Condition.asserter",
        "path" : "Condition.asserter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      }
    ]
  }
}

```
