# No Fixed Address - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **No Fixed Address**

## Extension: No Fixed Address 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-nofixedaddress | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:ExtensionNoFixedAddress |

This extension applies to the Address datatype and indicates that there is an assertion that there is no fixed address.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Patient Profile](StructureDefinition-profile-patient.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/ext-nofixedaddress)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-nofixedaddress.csv), [Excel](StructureDefinition-ext-nofixedaddress.xlsx), [Schematron](StructureDefinition-ext-nofixedaddress.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-nofixedaddress",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-nofixedaddress",
  "version" : "1.2.0",
  "name" : "ExtensionNoFixedAddress",
  "title" : "Extension: No fixed address flag",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "This extension applies to the Address datatype and indicates that there is an assertion that there is no fixed address.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Address"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "No Fixed Address indicator",
        "comment" : "An assertion that there is no fixed address",
        "min" : 0,
        "max" : "1",
        "isModifier" : false
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "min" : 1,
        "max" : "1",
        "fixedUri" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-nofixedaddress"
      },
      {
        "id" : "Extension.valueBoolean",
        "path" : "Extension.valueBoolean",
        "definition" : "Boolean flag representing an assertion",
        "min" : 1,
        "max" : "1",
        "fixedBoolean" : true
      }
    ]
  }
}

```
