# Aboriginal Identity Indicator - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Aboriginal Identity Indicator**

## Extension: Aboriginal Identity Indicator 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-aboriginalidentityindicator | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:ExtensionAboriginalIdentityIndicator |

A code classifying the person's self identity as an aboriginal person

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Patient Profile](StructureDefinition-profile-patient.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/ext-aboriginalidentityindicator)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-aboriginalidentityindicator.csv), [Excel](StructureDefinition-ext-aboriginalidentityindicator.xlsx), [Schematron](StructureDefinition-ext-aboriginalidentityindicator.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-aboriginalidentityindicator",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-aboriginalidentityindicator",
  "version" : "1.2.0",
  "name" : "ExtensionAboriginalIdentityIndicator",
  "title" : "Extension: Aboriginal Identity Indicator",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "A code classifying the person's self identity as an aboriginal person",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "A code classifying the person's self identity as an aboriginal person.",
        "comment" : "This attribute is based on the belief of the person or the person reporting the attribute, not on any formal analysis of genetic, geneological or historical relationships as these would need to be captured as observations.",
        "min" : 0,
        "max" : "1",
        "isModifier" : false
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "min" : 1,
        "max" : "1",
        "fixedUri" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-aboriginalidentityindicator"
      },
      {
        "id" : "Extension.valueCoding",
        "path" : "Extension.valueCoding",
        "definition" : "Concepts classifying the person as an aboriginal sharing common history, traits or geographical origin",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "preferred",
          "description" : "One of [self-reported codes](https://fhir.infoway-inforoute.ca/ValueSet/aboriginalidentityindicator) identity as an aboriginal person",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/aboriginalidentityindicator"
        }
      },
      {
        "id" : "Extension.valueCoding.system",
        "path" : "Extension.valueCoding.system",
        "short" : "Identity of the terminology system",
        "min" : 1
      },
      {
        "id" : "Extension.valueCoding.code",
        "path" : "Extension.valueCoding.code",
        "short" : "Code defining aboriginal identity indicator concept",
        "definition" : "One of [self-reported codes](https://fhir.infoway-inforoute.ca/ValueSet/aboriginalidentityindicator) identity as an aboriginal person",
        "min" : 1
      },
      {
        "id" : "Extension.valueCoding.display",
        "path" : "Extension.valueCoding.display",
        "short" : "Optional description of the aboriginal identity indicator code",
        "definition" : "Plain text representation of the aboriginal identity indicator concept"
      }
    ]
  }
}

```
