# hl7.fhir.ca.baseline#1.2.0: Canadian Baseline

## Pages

* [Home](index.md)
* [General Guidance](general-guidance.md)
* [Vital Signs](vitalsigns-profiles.md)
* [Downloads](downloads.md)
* [Development Process](developmentprocess.md)
* [Artifact List](artifacts.md)
* [Security](security.md)
* [FHIR Artifacts](allartifacts.md)

## Resources

### CodeSystems

* [Aboriginal Identity Type](CodeSystem-aboriginalidentitytype.md)

### ValueSets

* [Aboriginal Identity Group](ValueSet-aboriginalidentitygroup.md)
* [Aboriginal Identity Indicator](ValueSet-aboriginalidentityindicator.md)
* [Birth Sex](ValueSet-birthsex.md)
* [Encounter Type](ValueSet-encountertype.md)
* [EthnicityCode](ValueSet-ethnicitycode.md)
* [HealthcareProviderRoleType](ValueSet-healthcareproviderroletype.md)
* [Health Concern Code](ValueSet-healthconcerncode.md)
* [PractitionerSpecialty](ValueSet-practitionerspecialty.md)
* [Prescription Drug Form](ValueSet-prescriptiondrugform.md)
* [Prescription Medicinal Product](ValueSet-prescriptionmedicinalproduct.md)
* [QualifiedRoleType](ValueSet-qualifiedroletype.md)
* [Vaccine Codes](ValueSet-vaccinecodes.md)

### Complex-type Profiles

* [Identifier DataType Profile (CA Baseline)](StructureDefinition-profile-identifier.md)

### Resource Profiles

* [AllergyIntolerance Profile](StructureDefinition-profile-allergyintolerance.md)
* [Condition Profile](StructureDefinition-profile-condition.md)
* [Device Profile (Medical and Non-medical)](StructureDefinition-profile-device-medical.md)
* [Device Profile (Implantable)](StructureDefinition-profile-device.md)
* [DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-profile-diagnosticreport.md)
* [Diagnostic Report for Report and Note Exchange Profile](StructureDefinition-profile-diagnosticreportnote.md)
* [DocumentReference Profile for metadata about the document](StructureDefinition-profile-documentreference.md)
* [Encounter Profile](StructureDefinition-profile-encounter.md)
* [Immunization Profile](StructureDefinition-profile-immunization.md)
* [ImmunizationRecommendation Profile](StructureDefinition-profile-immunizationrecommendation.md)
* [Location Profile](StructureDefinition-profile-location.md)
* [Medication Profile](StructureDefinition-profile-medication.md)
* [MedicationAdministration Profile](StructureDefinition-profile-medicationadministration.md)
* [MedicationDispense Profile](StructureDefinition-profile-medicationdispense.md)
* [MedicationRequest Profile](StructureDefinition-profile-medicationrequest.md)
* [MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md)
* [Observation Profile (Laboratory Results)](StructureDefinition-profile-observation-results.md)
* [Observation Profile (General Use)](StructureDefinition-profile-observation.md)
* [Organization Profile](StructureDefinition-profile-organization.md)
* [OrganizationAffiliation Profile](StructureDefinition-profile-organizationaffiliation.md)
* [Patient Profile](StructureDefinition-profile-patient.md)
* [Practitioner Profile (Provider Registry)](StructureDefinition-profile-practitioner-registry.md)
* [Practitioner Profile (General)](StructureDefinition-profile-practitioner.md)
* [PractitionerRole Profile (Provider Registry)](StructureDefinition-profile-practitionerrole-registry.md)
* [PractitionerRole Profile (General)](StructureDefinition-profile-practitionerrole.md)
* [Procedure Profile](StructureDefinition-profile-procedure.md)
* [ServiceRequest Profile for Results Reporting](StructureDefinition-profile-servicerequest.md)

### Extensions

* [Extension: Aboriginal Identity Group](StructureDefinition-ext-aboriginalidentitygroup.md)
* [Extension: Aboriginal Identity Indicator](StructureDefinition-ext-aboriginalidentityindicator.md)
* [Extension: Date Estimated Flag](StructureDefinition-ext-dateestimated.md)
* [Extension: Individual is deceased flag or date](StructureDefinition-ext-deceased.md)
* [Extension: Ethnicity](StructureDefinition-ext-ethnicity.md)
* [Extension: Identifier Version](StructureDefinition-ext-identifierversion.md)
* [Extension: No fixed address flag](StructureDefinition-ext-nofixedaddress.md)
* [Extension: Birth Sex](StructureDefinition-ext-patientbirthsex.md)
* [Extension: RoleStatus](StructureDefinition-ext-rolestatus.md)
* [Extension: ServiceLanguage](StructureDefinition-ext-servicelanguage.md)
* [Extension: StatusReason](StructureDefinition-ext-statusreason.md)

### ImplementationGuides

* [Canadian Baseline](index.md)
