# Artifact List - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* **Artifact List**

## Artifact List

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Profiles 

Constraints on FHIR resources to be adhered to as part of the CA-Baseline implementation guide

| | |
| :--- | :--- |
| [AllergyIntolerance Profile](StructureDefinition-profile-allergyintolerance.md) | Proposed constraints and extensions on the AllergyIntolerance Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [Condition Profile](StructureDefinition-profile-condition.md) | Proposed constraints and extensions on the Condition Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [Device Profile (Implantable)](StructureDefinition-profile-device.md) | Proposed constraints on the Device resource for the minimal set of data to query and retrieve a patient's implantable device. |
| [Device Profile (Medical and Non-medical)](StructureDefinition-profile-device-medical.md) | Proposed constraints on the Device resource for the minimal set of data to query and retrieve a medical or non-medical device. |
| [DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-profile-diagnosticreport.md) | Proposed constraints on the DiagnosticReport resource to set minimum expectations to laboratory and similar results reporting. |
| [Document Reference Profile](StructureDefinition-profile-documentreference.md) | Proposed constraints and extensions on the DocumentReference Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [Encounter Profile](StructureDefinition-profile-encounter.md) | Proposed constraints and extensions on the Encounter Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [Immunization Profile](StructureDefinition-profile-immunization.md) | Proposed constraints and extensions on the Immunization Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [ImmunizationRecommendation Profile](StructureDefinition-profile-immunizationrecommendation.md) | Proposed constraints and extensions on the ImmunizationRecommendation Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [Location Profile](StructureDefinition-profile-location.md) | Proposed constraints and extensions on the Location Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [Medication Profile](StructureDefinition-profile-medication.md) | Proposed constraints and extensions on the Medication Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [MedicationAdministration Profile](StructureDefinition-profile-medicationadministration.md) | Proposed constraints and extensions on the MedicationAdministration Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [MedicationDispense Profile](StructureDefinition-profile-medicationdispense.md) | Proposed constraints and extensions on the MedicationDispense Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [MedicationRequest Profile](StructureDefinition-profile-medicationrequest.md) | Proposed constraints and extensions on the MedicationRequest Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md) | Proposed constraints and extensions on the MedicationStatement Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [Observation Profile (General)](StructureDefinition-profile-observation.md) | Proposed constraints and extensions on the Observation Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [Observation Profile (Laboratory Results)](StructureDefinition-profile-observation-results.md) | Proposed constraints and extensions on the Observation Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [Organization Profile](StructureDefinition-profile-organization.md) | Proposed constraints and extensions on the Organization Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [OrganizationAffiliation Profile](StructureDefinition-profile-organizationaffiliation.md) | Proposed constraints and extensions on the OrganizationAffiliation Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [Patient Profile](StructureDefinition-profile-patient.md) | Proposed constraints and extensions on the Patient Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [Practitioner Profile (General)](StructureDefinition-profile-practitioner.md) | Proposed constraints and extensions on the Practitioner Resource for general use. |
| [Practitioner Profile (Provider Registry)](StructureDefinition-profile-practitioner-registry.md) | Proposed constraints and extensions on the Practitioner Resource for use by Provider Registry systems. |
| [PractitionerRole Profile (General)](StructureDefinition-profile-practitionerrole.md) | Proposed constraints and extensions on the PractitionerRole Resource for general use. |
| [PractitionerRole Profile (Provider Registry)](StructureDefinition-profile-practitionerrole-registry.md) | Proposed constraints and extensions on the PractitionerRole Resource for use by Provider Registry systems. |
| [Procedure Profile](StructureDefinition-profile-procedure.md) | Proposed constraints and extensions on the Procedure Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |
| [ServiceRequest Profile](StructureDefinition-profile-servicerequest.md) | Proposed constraints on the ServiceRequest resource for the minimal set of data required to request for service such as diagnostic investigations, treatments, or operations to be performed. |
| [Identifier DataType Profile (CA Baseline)](StructureDefinition-profile-identifier.md) | This profile constrains the identifier data type to support minimum expectations of Canadian systems when expressing the identifier data type. |

### Extensions 

Extensions defined as part of the CA-Baseline implementation guide

| | |
| :--- | :--- |
| [Aboriginal Identity Group](StructureDefinition-ext-aboriginalidentitygroup.md) | A code classifying the person's aboriginal identity |
| [Aboriginal Identity Indicator](StructureDefinition-ext-aboriginalidentityindicator.md) | A code classifying the person's self identity as an aboriginal person |
| [Birth Sex](StructureDefinition-ext-patientbirthsex.md) | A code classifying the person's sex assigned at birth. Replicates the birthsex extension in US-Core-R4 for interoperability. |
| [Deceased](StructureDefinition-ext-deceased.md) | Flag or date indicating that an individual is deceased. |
| [Ethnicity](StructureDefinition-ext-ethnicity.md) | A code classifying the person's ethnic group or ethnicity as the category of people who identify with each other, usually on the basis of a presumed common genealogy or ancestry or on other similarities. |
| [Date Estimated Flag](StructureDefinition-ext-dateestimated.md) | If true, indicates that information entered is an estimate and may not be precise. |
| [Identifier Version](StructureDefinition-ext-identifierversion.md) | A version string indicating the currency/validity of an identifier. |
| [No Fixed Address](StructureDefinition-ext-nofixedaddress.md) | This extension applies to the Address datatype and indicates that there is an assertion that there is no fixed address. |
| [Role Status](StructureDefinition-ext-rolestatus.md) | Represents the status of the Role, as defined by the HL7v3 Role class state machine. |
| [Service Language](StructureDefinition-ext-servicelanguage.md) | Indentifies languages that that services are provided in. |
| [Status Reason](StructureDefinition-ext-statusreason.md) | Provides a textual description (reason) for a status. |

### Terminology 

ValueSets (and Code Systems) defined for use within the CA-Baseline implementation guide

| | |
| :--- | :--- |
| [Aboriginal Identity Group](ValueSet-aboriginalidentitygroup.md) | Represents codes for Aboriginal Identity |
| [Aboriginal Identity Indicator](ValueSet-aboriginalidentityindicator.md) | Represents the self identity as an Aboriginal Person |
| [Birth Sex](ValueSet-birthsex.md) | Codes for documenting sex at birth. (Replicates the birthsex ValueSet in US-Core-R4 for interoperability.) |
| [Encounter Type](ValueSet-encountertype.md) | The type of encounter: a specific code indicating type of service provided. This value set includes codes from SNOMED CT decending from the concept 308335008 (Patient encounter procedure (procedure)) |
| [Ethnicity Code](ValueSet-ethnicitycode.md) | Codes representing a self-reported ethnic group. This should not be confused with citizenship or nationality. |
| [Health Concern Codes](ValueSet-healthconcerncode.md) | Clinical problems, conditions, diagnoses, symptoms, findings and complaints, as interpreted by the provider. |
| [Prescription Drug Form](ValueSet-prescriptiondrugform.md) | The list of forms in which compounded drugs or active ingredients can be dispensed to the patient. |
| [Prescription Medicinal Product](ValueSet-prescriptionmedicinalproduct.md) | The list of commonly used Medicinal products used for prescribing and dispensing in Canada. |
| [Vaccine Codes](ValueSet-vaccinecodes.md) | **Placeholder**\nCurrent and historical vaccines are published as separate lists by Canada Health Infoway. |
| [Practitioner Specialty Codes](ValueSet-practitionerspecialty.md) | Defines the clinical, medical, surgical or other healthcare-related service specialty of a practitioner who interacts, treats or provides such services to or for a patient.This resource is an informative value set; a[normative subset](https://tgateway.infoway-inforoute.ca/vs/practitionerspecialty)can be found on Canada Health Infoway's[Terminology Gateway](https://tgateway.infoway-inforoute.ca). |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Diagnostic Report for Report and Note Exchange Profile](StructureDefinition-profile-diagnosticreportnote.md) | Proposed constraints and extensions on the Diagnostic Report Resource to support collection of diagnostic report information for reports and notes. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [HealthcareProviderRoleType](ValueSet-healthcareproviderroletype.md) | A role type that is used to categorize an entity that delivers health care in an expected and professional manner to an entity in need of health care services. Examples: Registered Nurse, Chiropractor, Physician, Custodial Care Clinic.This resource is an informative value set; a[normative subset](https://tgateway.infoway-inforoute.ca/vs/healthcareproviderroletype)can be found on Canada Health Infoway's[Terminology Gateway](https://tgateway.infoway-inforoute.ca). |
| [QualifiedRoleType](ValueSet-qualifiedroletype.md) | A code for the degree or educational rank that the credential specifies. May also apply to an Expertise type.This resource is an informative value set; a[normative subset](https://tgateway.infoway-inforoute.ca/vs/qualifiedroletype)can be found on Canada Health Infoway's[Terminology Gateway](https://tgateway.infoway-inforoute.ca). |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Aboriginal Identity Type](CodeSystem-aboriginalidentitytype.md) | Represents codes for Aboriginal Identity |

