# Health Concern Codes - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Health Concern Codes**

## ValueSet: Health Concern Codes 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/ValueSet/healthconcerncode | *Version*:1.2.0 |
| Draft as of 2025-10-10 | *Computable Name*:HealthConcernCode |

 
Clinical problems, conditions, diagnoses, symptoms, findings and complaints, as interpreted by the provider.[Published here by Canada Health Infoway](https://tgateway.infoway-inforoute.ca/singlesubset.html?id=2.16.840.1.113883.2.20.3.278&versionid=20181031). 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

* Import all the codes that are contained in [HealthConcernCode](https://terminologystandardsservice.ca/tx/fhir/ValueSet/SS-HealthConcernCode-1-0-0)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "healthconcerncode",
  "url" : "http://hl7.org/fhir/ca/baseline/ValueSet/healthconcerncode",
  "version" : "1.2.0",
  "name" : "HealthConcernCode",
  "title" : "Health Concern Code",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-10T19:18:14+00:00",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Clinical problems, conditions, diagnoses, symptoms, findings and complaints, as interpreted by the provider. [Published here by Canada Health Infoway](https://tgateway.infoway-inforoute.ca/singlesubset.html?id=2.16.840.1.113883.2.20.3.278&versionid=20181031).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "https://fhir.infoway-inforoute.ca/ValueSet/healthconcerncode"
        ]
      }
    ]
  }
}

```
