# HealthcareProviderRoleType - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **HealthcareProviderRoleType**

## ValueSet: HealthcareProviderRoleType 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.infoway-inforoute.ca/ValueSet/healthcareproviderroletype | *Version*:1.2.0 |
| Active as of 2025-10-10 | *Computable Name*:HealthcareProviderRoleType |
| **Copyright/Legal**: Copyright © 2024 Canada Health Infoway. All rights reserved.[Terms of Use and License Agreements](https://ic.infoway-inforoute.ca/en/about/tou).[Privacy Policy](https://www.infoway-inforoute.ca/en/legal/privacy-policy). | |

 
A role type that is used to categorize an entity that delivers health care in an expected and professional manner to an entity in need of health care services. Examples: Registered Nurse, Chiropractor, Physician, Custodial Care Clinic. 
This resource is an informative value set; a[normative subset](https://tgateway.infoway-inforoute.ca/vs/healthcareproviderroletype)can be found on Canada Health Infoway's[Terminology Gateway](https://tgateway.infoway-inforoute.ca). 

 **References** 

* [PractitionerRole Profile (General)](StructureDefinition-profile-practitionerrole.md)
* [PractitionerRole Profile (Provider Registry)](StructureDefinition-profile-practitionerrole-registry.md)

### Logical Definition (CLD)

No formal definition provided for this value set

 

### Expansion

This value set contains 0 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "healthcareproviderroletype",
  "url" : "https://fhir.infoway-inforoute.ca/ValueSet/healthcareproviderroletype",
  "version" : "1.2.0",
  "name" : "HealthcareProviderRoleType",
  "title" : "HealthcareProviderRoleType",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-10T19:18:14+00:00",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "A role type that is used to categorize an entity that delivers health care in an expected and professional manner to an entity in need of health care services. Examples: Registered Nurse, Chiropractor, Physician, Custodial Care Clinic.\n\nThis resource is an informative value set; a [normative subset](https://tgateway.infoway-inforoute.ca/vs/healthcareproviderroletype) can be found on Canada Health Infoway's [Terminology Gateway](https://tgateway.infoway-inforoute.ca).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2024 Canada Health Infoway. All rights reserved. [Terms of Use and License Agreements](https://ic.infoway-inforoute.ca/en/about/tou). [Privacy Policy](https://www.infoway-inforoute.ca/en/legal/privacy-policy)."
}

```
