# PractitionerRole Profile (General) - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **PractitionerRole Profile (General)**

## Resource Profile: PractitionerRole Profile (General) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:PractitionerRoleProfile |

 
Proposed constraints and extensions on the PractitionerRole Resource for general use. 

# CA Baseline PractitionerRole Profile

This PractitionerRole profile sets minimum expectations for the PractitionerRole resource to record, search and fetch the recording of the location and types of services that Practitioner is able to provide for an organization.

This profile defines localization concepts for use in an Canadian context.

## Differences from US Core

**Note:** This profile was generated from [HL7 PractitionerRole StructureDefinition](http://hl7.org/fhir/R4/practitionerrole.html) and constrained during a review of US Core R4 equivalent profile(s) and a review against Canadian sources.

The following differences are noted from the [US Core R4 PractitionerRole Profile](hl7.org/fhir/us/core/STU4/StructureDefinition-us-core-practitionerrole.md):

* MS Differences: US Core R4 PractitionerRole profile includes additional MS constraints on identifier, organization, code, location, telecom.system, telecom.value, and endpoint.
* Cardinality Differences: None
* Terminology Differences: US Core binds PractitionerRole.code to their National Uniform Claim Committet (NUCC) Taxonomy, and binds PractitionerRole.specialty to their Healthcare Provider Taxonomy valueset. Both are expected to be realm specific.
* Invariant Differences: US Core R4 PractitionerRole profile includes an additional invariant necessitating a reference to practitioner, org, healthcareService, or location be present

## Mandatory Data Elements

All elements or attributes defined in FHIR have cardinality as part of their definition - a minimum number of required appearances and a maximum number.

Most elements in FHIR specification have a minimum cardinality of **0**, which means that they may be missing from a resource when it is exchanged between systems.

In this Canadian Baseline PractitionerRole Profile all elements are optional, i.e., there is no element with a minimum cardinality of **1**. However, some optional elements (e.g., identifier, telecom) have required components that MUST be present if that optional element is provided.

### Data Absent Reason

In situations where the minimum cardinality of an element or attribute is **1** and information is missing and the Responder knows the precise reason for the absence of data, Responders SHALL send the reason for the missing information using values (such as [NullFlavor](https://www.hl7.org/fhir/extension-iso21090-nullflavor.html)) from the value set where they exist or using the [DataAbsentReason](http://hl7.org/fhir/StructureDefinition/data-absent-reason) extension.

## Must Support Data Elements

Some elements are labeled as MustSupport meaning that implementations that produce or consume resources SHALL provide "support" for the element in some meaningful way (see [Must Support](https://build.fhir.org/ig/HL7-Canada/ca-baseline/general-guidance.html#must-support) definition).

The following elements are marked as Must Support in the PractitionerRole profile:

**Must Support elements:**

* reference to a practitioner
* contact detail (e.g. a telephone number or an email address) - inclusive of telecom system
* specialty

## Best Practices/"Should" Support

**identifier**: It is recommended to have an identifier associated with PractitionerRole to assist in searches, however not every implementation (especially legacy implementations that combined both concepts of practitioner & practitionerRole) will include an identifier practitioner role. Given the scope and principles of the CA Baseline, the cardinality on this element was relaxed back to its base cardinality after receiving community feedback from FHIR IGuides that could not support the expectation in their existing implementation(s).

## Invariants

The invariant necessitating either code or specialty be present was removed after review against Canadian FHIR rpracititoner registry implementations identified challenges with some legacy systems (registry and otherwise) that have cpmmon use cases for PractitionerRole that do not include specialty or code.

## Usage Note

This PractitionerRole profile is intended for general use, e.g. to be included into a Bundle along with the Practitioner resource.

**Usages:**

* Derived from this Profile: [PractitionerRole Profile (Provider Registry)](StructureDefinition-profile-practitionerrole-registry.md)
* Refer to this Profile: [AllergyIntolerance Profile](StructureDefinition-profile-allergyintolerance.md), [Condition Profile](StructureDefinition-profile-condition.md), [DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-profile-diagnosticreport.md), [DocumentReference Profile for metadata about the document](StructureDefinition-profile-documentreference.md)...Show 9 more,[Encounter Profile](StructureDefinition-profile-encounter.md),[Immunization Profile](StructureDefinition-profile-immunization.md),[MedicationAdministration Profile](StructureDefinition-profile-medicationadministration.md),[MedicationDispense Profile](StructureDefinition-profile-medicationdispense.md),[MedicationRequest Profile](StructureDefinition-profile-medicationrequest.md),[MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md),[Observation Profile (Laboratory Results)](StructureDefinition-profile-observation-results.md),[Procedure Profile](StructureDefinition-profile-procedure.md)and[ServiceRequest Profile for Results Reporting](StructureDefinition-profile-servicerequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-practitionerrole)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-practitionerrole.csv), [Excel](StructureDefinition-profile-practitionerrole.xlsx), [Schematron](StructureDefinition-profile-practitionerrole.sch) 

### Notes:

## Identifiers

Multiple types of provider identifiers may be used in PractitionerRole.identifier element in the Canadian context:

* Provincial health plan provider/ Billing number
* Licence Number
* Medical Doctor Number

Implementers may use other identifiers to capture in a more specific way such as internal provider number, jurisdictions providing credentials. The full list of possible identifier types is in [Canadian URI Registry](https://simplifier.net/canadianuriregistry/~resources?category=NamingSystem)

In some cases, the same license number can be used as the provider identifier and provider's qualification identifier.

## Telecom

A provider may have multiple ways to be contacted with different uses or applicable periods. This PractitionerRole profile allows multiple contact points (e.g. a telephone number or an email address) by which the individual may be contacted.

To indicate the preferred way to contact use Practitioner.telecom.rank attribute (i.e., the [ContactPoint.rank](https://www.hl7.org/fhir/datatypes.html#contactpoint) component) that specifies a preferred order in which to use a set of contacts. ContactPoints with lower rank values are more preferred than those with higher rank values.

### Role

Roles which this practitioner is authorized to perform for the organization are defined by Canadian [HealthcareProviderRoleType](https://tgateway.infoway-inforoute.ca/singlesubset.html?id=2.16.840.1.113883.2.20.3.48&versionid=20190813) value set as the coded representation of the provider's credentials. Credential defines a role type that is used to categorize an entity that delivers health care in an expected and professional manner to an entity in need of health care services.

The binding strength for the **PractitionerRole.code** element is [Preferred](https://www.hl7.org/fhir/terminologies.html#preferred) meaning that implementers are encouraged to draw codes from the specified code system for interoperability purposes but are not required to do so to be considered conformant.

### Specialty

Specific specialty of the practitioner defines the clinical, medical, surgical or other healthcare-related service specialty of a practitioner who interacts, treats or provides such services to or for a patient. This profile recommends to use Canadian [PractitionerSpecialty](https://tgateway.infoway-inforoute.ca/singlesubset.html?id=2.16.840.1.113883.3.239.12.38) value set for speciality codes.

The binding strength for the **PractitionerRole.speciality** element is [Preferred](https://www.hl7.org/fhir/terminologies.html#preferred) meaning that implementers are encouraged to draw codes from the specified code system for interoperability purposes but are not required to do so to be considered conformant.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-practitionerrole",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
  "version" : "1.2.0",
  "name" : "PractitionerRoleProfile",
  "title" : "PractitionerRole Profile (General)",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the PractitionerRole Resource for general use.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/PractitionerRole",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole",
        "short" : "PractitionerRole Generic Profile",
        "definition" : "The PractitionerRole Generic Profile is scoped to general use and may be further constrained through other specialized profiles (e.g., PractitionerRole Registry Profile)"
      },
      {
        "id" : "PractitionerRole.identifier",
        "path" : "PractitionerRole.identifier",
        "comment" : "This element is considered SHOULD support and it is recommended to have an identifier associated with PractitionerRole to assist in searches, not every implementation (especially legacy implementations that combined both concepts of practitioner & practitionerRole) will include an identifier practioner role.",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-identifier"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.practitioner",
        "path" : "PractitionerRole.practitioner",
        "short" : "Practitioner that is able to provide the defined services for the organization.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.code",
        "path" : "PractitionerRole.code",
        "short" : "HealthcareProviderRoleType",
        "comment" : "The binding strength of this element is [Preferred](https://www.hl7.org/fhir/terminologies.html#strength), meaning that codes are encouraged to draw from the HealthcareProviderRoleType code system for interoperability purposes but are not required to do so to be considered conformant.",
        "binding" : {
          "strength" : "preferred",
          "description" : "A role type that is used to categorize an entity that delivers health care in an expected and professional manner to an entity in need of health care services. Examples: Registered Nurse, Chiropractor, Physician, Custodial Care Clinic.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/healthcareproviderroletype"
        }
      },
      {
        "id" : "PractitionerRole.specialty",
        "path" : "PractitionerRole.specialty",
        "short" : "PractitionerSpecialty",
        "comment" : "The binding strength of this element is [Preferred](https://www.hl7.org/fhir/terminologies.html#strength), meaning that codes are encouraged to draw from the PractitionerSpecialty code system for interoperability purposes but are not required to do so to be considered conformant.",
        "binding" : {
          "strength" : "preferred",
          "description" : "Defines the clinical, medical, surgical or other healthcare-related service specialty of a practitioner who interacts, treats or provides such services to or for a patient.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/practitionerspecialty"
        }
      },
      {
        "id" : "PractitionerRole.telecom",
        "path" : "PractitionerRole.telecom"
      },
      {
        "id" : "PractitionerRole.telecom.system",
        "path" : "PractitionerRole.telecom.system",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.telecom.value",
        "path" : "PractitionerRole.telecom.value",
        "min" : 1
      }
    ]
  }
}

```
