# Practitioner Profile (General) - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Practitioner Profile (General)**

## Resource Profile: Practitioner Profile (General) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:PractitionerProfile |

 
Proposed constraints and extensions on the Practitioner Resource for general use. 

# CA Baseline Practitioner Profile

This Practitioner profile sets minimum expectations for the Practitioner resource to record, search and fetch demographics and other administrative information about a person who is directly or indirectly involved in the provisioning of healthcare.

This profile defines localization concepts for use in an Canadian context.

## Differences from US Core

**Note:** This profile was generated from [HL7 Practitioner StructureDefinition](http://hl7.org/fhir/R4/practitioner.html) on 2020-02-19 and constrained during a review of US Core and a review against Canadian sources.

## Mandatory Data Elements

All elements or attributes defined in FHIR have cardinality as part of their definition - a minimum number of required appearances and a maximum number.

Most elements in FHIR specification have a minimum cardinality of **0**, which means that they may be missing from a resource when it is exchanged between systems.

In this Canadian Baseline Practitioner Profile all elements are optional, i.e., there is no element with a minimum cardinality of **1**. However, some optional elements (e.g., identifier) have required components that MUST be present if that optional element is provided.

### Data Absent Reason

In situations where the minimum cardinality of an element or attribute is **1** and information is missing and the Responder knows the precise reason for the absence of data, Responders SHALL send the reason for the missing information using values (such as [NullFlavor](https://www.hl7.org/fhir/extension-iso21090-nullflavor.html)) from the value set where they exist or using the [DataAbsentReason](http://hl7.org/fhir/StructureDefinition/data-absent-reason) extension.

## Must Support Data Elements

Some elements are labeled as MustSupport meaning that implementations that produce or consume resources SHALL provide "support" for the element in some meaningful way (see [Must Support](https://build.fhir.org/ig/HL7-Canada/ca-baseline/general-guidance.html#must-support) definition).

Following elements are marked as Must Support in the Practitioner profile to aid record matching in databases with many pediatric records.

**Must Support elements:**

1. an identifier
1. a practitioner name

## Usage Note

This Practitioner profile is intended for general use, e.g. to be included into a Bundle along with the Patient resource (Patient.generalPractitioner).

**Usages:**

* Derived from this Profile: [Practitioner Profile (Provider Registry)](StructureDefinition-profile-practitioner-registry.md)
* Refer to this Profile: [AllergyIntolerance Profile](StructureDefinition-profile-allergyintolerance.md), [Condition Profile](StructureDefinition-profile-condition.md), [DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-profile-diagnosticreport.md), [Diagnostic Report for Report and Note Exchange Profile](StructureDefinition-profile-diagnosticreportnote.md)...Show 12 more,[DocumentReference Profile for metadata about the document](StructureDefinition-profile-documentreference.md),[Encounter Profile](StructureDefinition-profile-encounter.md),[Immunization Profile](StructureDefinition-profile-immunization.md),[MedicationAdministration Profile](StructureDefinition-profile-medicationadministration.md),[MedicationDispense Profile](StructureDefinition-profile-medicationdispense.md),[MedicationRequest Profile](StructureDefinition-profile-medicationrequest.md),[MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md),[Observation Profile (Laboratory Results)](StructureDefinition-profile-observation-results.md),[PractitionerRole Profile (Provider Registry)](StructureDefinition-profile-practitionerrole-registry.md),[PractitionerRole Profile (General)](StructureDefinition-profile-practitionerrole.md),[Procedure Profile](StructureDefinition-profile-procedure.md)and[ServiceRequest Profile for Results Reporting](StructureDefinition-profile-servicerequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-practitioner)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-practitioner.csv), [Excel](StructureDefinition-profile-practitioner.xlsx), [Schematron](StructureDefinition-profile-practitioner.sch) 

### Notes:

## Identifiers

Multiple types of provider identifiers may be used in Practitioner.identifier element in the Canadian context:

* Provincial health plan provider/ Billing number
* License Number
* Medical Doctor Number

Implementers may use other identifiers to capture in a more specific way such as internal provider number, jurisdictions providing credentials. The full list of possible identifier types is in [Canadian URI Registry](https://simplifier.net/canadianuriregistry/~resources?category=NamingSystem)

In some cases, the same license number can be used as the provider identifier and provider's qualification identifier.

## Telecom

A provider may have multiple ways to be contacted with different uses or applicable periods. This Practitioner profile allows multiple contact points (e.g. a telephone number or an email address) by which the individual may be contacted.

To indicate the preferred way to contact use Practitioner.telecom.rank attribute (i.e., the [ContactPoint.rank](https://www.hl7.org/fhir/datatypes.html#contactpoint) component) that specifies a preferred order in which to use a set of contacts. ContactPoints with lower rank values are more preferred than those with higher rank values.

## Address

The Practitioner profile is provided for use in a Canadian context where some constraint on content is desirable to guarantee the quality of the Canadian address whilst still supporting other type of address (e.g., other countries or unstructured addresses).

### Canadian postal code

If an address in the Practitioner resource instance represents Canadian address, it SHOULD follow Canadian postal code format.

The Canadian Postal Code SHOULD be a six-character uniformly structured uppercase alphanumeric code in the form of "ANA NAN", where "A" represents an alphabetic character and "N" represents a numeric character, with one space between the first three and the last three characters.

A hyphen SHOULD NOT be used (example of unacceptable format: T0L-1K0).

### Preferred

The Practitioner.address MAY have a [Preferred](http://hl7.org/fhir/StructureDefinition/iso21090-preferred) extension. This is the FHIR standard defined extension used as a flag denoting whether parent address item is preferred.

### Qualifications

This profile recommends to use Canadian [QualifiedRoleType](https://tgateway.infoway-inforoute.ca/singlesubset.html?id=2.16.840.1.113883.2.20.3.48) value set as the coded representation of the provider's qualification. This value set lists codes for the degree or educational rank that the credential specifies. It may also apply to an Expertise type.

The binding strength for the Practitioner.qualification.code element is [Preferred](https://www.hl7.org/fhir/terminologies.html#preferred) meaning that implementers are encouraged to draw codes from the specified code system for interoperability purposes but are not required to do so to be considered conformant.

Example:

```
"code": {
  "coding": [
    {
      "system": "https://fhir.infoway-inforoute.ca/CodeSystem/scpqual",
      "code": "BSC",
      "display": "Bachelor of Science Degree"
    }
  ],
  "text": "Bachelor of Science Degree"
}

```



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-practitioner",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
  "version" : "1.2.0",
  "name" : "PractitionerProfile",
  "title" : "Practitioner Profile (General)",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the Practitioner Resource for general use.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Practitioner",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner",
        "short" : "Practitioner Profile",
        "definition" : "The Practitioner Profile is based upon the core FHIR Practitioner Resource"
      },
      {
        "id" : "Practitioner.identifier",
        "path" : "Practitioner.identifier",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-identifier"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name",
        "path" : "Practitioner.name",
        "constraint" : [
          {
            "key" : "ca-baseline-practitioner-name",
            "severity" : "error",
            "human" : "Either name.given and/or name.family SHALL be present or a Data Absent Reason Extension SHALL be present",
            "expression" : "(family.exists() or given.exists()) xor extension.where(url='http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "xpath" : "(/f:extension/@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason' and not(/f:family or /f:given)) or (not(/f:extension/@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason') and (/f:family or /f:given))"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name.family",
        "path" : "Practitioner.name.family",
        "condition" : ["ca-baseline-practitioner-name"]
      },
      {
        "id" : "Practitioner.name.given",
        "path" : "Practitioner.name.given",
        "condition" : ["ca-baseline-practitioner-name"]
      },
      {
        "id" : "Practitioner.address.extension",
        "path" : "Practitioner.address.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Practitioner.address.extension:preferred",
        "path" : "Practitioner.address.extension",
        "sliceName" : "preferred",
        "short" : "HL7 Preferred Address Flag extension",
        "definition" : "Flag denoting whether parent address item is preferred",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/iso21090-preferred"]
          }
        ]
      },
      {
        "id" : "Practitioner.qualification",
        "path" : "Practitioner.qualification",
        "definition" : "A code system for the degree or educational rank that the credential specifies. May also apply to an Expertise type.",
        "comment" : "The binding strength of this element is [Preferred](https://www.hl7.org/fhir/terminologies.html#strength), meaning that codes are encouraged to draw from the QualifiedRoleType code system for interoperability purposes but are not required to do so to be considered conformant.",
        "binding" : {
          "strength" : "example",
          "description" : "A code system for the degree or educational rank that the credential specifies",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/qualifiedroletype"
        }
      }
    ]
  }
}

```
