# Patient Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Patient Profile**

## Resource Profile: Patient Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient | *Version*:1.2.0 |
| Draft as of 2024-12-27 | *Computable Name*:PatientProfile |

 
Proposed constraints and extensions on the Patient Resource as scoped to human patients 

# CA Baseline Patient Profile

> This profile is seeking community and implementer feedback on whether further relaxation of the 1..1 cardinality is needed on the Patient.identifier.type & .system & .value elements.

Due Diligence Reviews identified the above elements as 1..1 cardinality but not in the equivalent eReferral Specification profile. This variance is believed to be due to the eReferral Specification profile not necessarily expecting a Patient to always have a health card (or at minimum a health card number). General consensus from Due Diligence Review is that the cardinalities should not be relaxed in the CA Baseline. Feedback can be provided through the Simplifier issue log for this profile.
Feedback can be provided through the[Simplifier issue log for this profile](https://simplifier.net/CanadianFHIRBaselineProfilesCA-Core/PatientProfile/~issues).

</div>

This Patient profile sets minimum expectations for the Patient resource to record, search and fetch demographics and other administrative information about an individual receiving care or other health-related services.

Since not all concepts are included within the base FHIR Patient resource, this profile defines localization concepts for use in an Canadian context.

## Mandatory Data Elements

All elements or attributes defined in FHIR have cardinality as part of their definition - a minimum number of required appearances and a maximum number.

Most elements in FHIR specification have a minimum cardinality of 0, which means that they may be missing from a resource when it is exchanged between systems.

In this Canadian Baseline Patient Profile all elements are optional, i.e., there is no element with a minimum cardinality of 1. However, some optional elements (e.g., identifier) have required components that MUST be present if that optional element is provided.

### Data Absent Reason

In situations where the minimum cardinality of an element or attribute is 1 and information is missing and the Responder knows the precise reason for the absence of data, Responders SHALL send the reason for the missing information using values (such as [NullFlavor](https://www.hl7.org/fhir/extension-iso21090-nullflavor.html)) from the value set where they exist or using the [DataAbsentReason](http://hl7.org/fhir/StructureDefinition/data-absent-reason) extension.

## Must Support Data Elements

Some elements are labeled as MustSupport meaning that implementations that produce or consume resources SHALL provide "support" for the element in some meaningful way (see [Must Support](https://build.fhir.org/ig/HL7-Canada/ca-baseline/general-guidance.html#must-support) definition).

Following elements are marked as Must Support in the Canadian Patient profile to aid record matching in databases with many pediatric records.

**Must Support elements:**

* an identifier
* a patient name
* a birth date

## Usage Note

Some of the typical use cases where the Patient profile may be used:

* Enterprise-wide information systems that manage patient registration and services ordering
* Local or cross-jurisdictional systems to query information about patients whose demographics data match data provided in the query parameters
* Synchronization of patient information between multiple ADT systems employed by healthcare enterprises

This profile includes an invariant that enforces that a family.name, given.name, or both be present. This is intended to enforce minimum constraints while allowing for cases where the patient may only have one name.

* Some jurisdictions with more rigid cardinality constraints on both family and given may be handling this today by populating the name of a patient into both fields
* Other jurisdictions may allow the population of either family or given

**Usages:**

* Refer to this Profile: [AllergyIntolerance Profile](StructureDefinition-profile-allergyintolerance.md), [Condition Profile](StructureDefinition-profile-condition.md), [Device Profile (Medical and Non-medical)](StructureDefinition-profile-device-medical.md), [Device Profile (Implantable)](StructureDefinition-profile-device.md)...Show 14 more,[DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-profile-diagnosticreport.md),[Diagnostic Report for Report and Note Exchange Profile](StructureDefinition-profile-diagnosticreportnote.md),[DocumentReference Profile for metadata about the document](StructureDefinition-profile-documentreference.md),[Encounter Profile](StructureDefinition-profile-encounter.md),[Immunization Profile](StructureDefinition-profile-immunization.md),[ImmunizationRecommendation Profile](StructureDefinition-profile-immunizationrecommendation.md),[MedicationAdministration Profile](StructureDefinition-profile-medicationadministration.md),[MedicationDispense Profile](StructureDefinition-profile-medicationdispense.md),[MedicationRequest Profile](StructureDefinition-profile-medicationrequest.md),[MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md),[Observation Profile (Laboratory Results)](StructureDefinition-profile-observation-results.md),[Observation Profile (General Use)](StructureDefinition-profile-observation.md),[Procedure Profile](StructureDefinition-profile-procedure.md)and[ServiceRequest Profile for Results Reporting](StructureDefinition-profile-servicerequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-patient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-patient.csv), [Excel](StructureDefinition-profile-patient.xlsx), [Schematron](StructureDefinition-profile-patient.sch) 

### Notes:

## Identifiers

Multiple individual healthcare identifiers may be provided in Patient.identifier element.

However, to support particular types of federal patient and person health numbers used by all jurisdictions across Canada following optional types are defined to uniquely identifying patients:

* Canadian Passport Number
* Jurisdictional Person Identification
* Jurisdictional Health Number

### Canadian Passport Number (PPN)

A unique number assigned to the document affirming that a person is a citizen of Canada.

URI to use with this identifier type: https://fhir.infoway-inforoute.ca/NamingSystem/ca-passport-number

**Example:**

```
{
  "type": {
    "coding": [
      {
        "system": "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code": "PPN"
      }
    ]
  },
  "system": "https://fhir.infoway-inforoute.ca/NamingSystem/ca-passport-number",
  "value": "AB123456",
  "period": {
    "start": "2005-05-11",
    "end": "2015-05-11"
  }
}

```

### Jurisdictional Patient Identifier Number (JPID)

This patient identifier type identifies a number issued in Canada to administer various government programs.

URIs used with this identifier type:

* Canada, Social Insurance Number (SIN) - https://fhir.infoway-inforoute.ca/NamingSystem/ca-social-insurance-number
* Canada Permanent Resident Card Number - https://fhir.infoway-inforoute.ca/NamingSystem/ca-permanent-resident-card-number
* Canada First Nation Indian registry number (band ID) - https://fhir.infoway-inforoute.ca/NamingSystem/ca-federal-firstnation-band-id
* Indigenous and Northern Affairs Canada health card number - https://fhir.infoway-inforoute.ca/NamingSystem/ca-indigenous-northern-affairs-number
* Interim Federal Health Program identifier - https://fhir.infoway-inforoute.ca/NamingSystem/ca-interim-federal-health-id

**Example:**

```
{
  "type": {
    "coding": [
      {
        "system": "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code": "JPID"
      }
    ]
  },
  "system": "https://fhir.infoway-inforoute.ca/NamingSystem/ca-social-insurance-number",
  "value": "923456789"
  }
}

```

### Jurisdictional Health Number (JHN)

Following URIs are registered to identify health card numbers for provinces and territories:

* Alberta - https://fhir.infoway-inforoute.ca/NamingSystem/ca-ab-patient-healthcare-id
* British Columbia - https://fhir.infoway-inforoute.ca/NamingSystem/ca-bc-patient-healthcare-id
* Manitoba - https://fhir.infoway-inforoute.ca/NamingSystem/ca-mb-patient-healthcare-id
* New Brunswick - https://fhir.infoway-inforoute.ca/NamingSystem/ca-nb-patient-healthcare-id
* Newfoundland and Labrador - https://fhir.infoway-inforoute.ca/NamingSystem/ca-nl-patient-healthcare-id
* Northwest Terrirories - https://fhir.infoway-inforoute.ca/NamingSystem/ca-nt-patient-healthcare-id
* Nova Scotia - https://fhir.infoway-inforoute.ca/NamingSystem/ca-ns-patient-healthcare-id
* Nunavut - https://fhir.infoway-inforoute.ca/NamingSystem/ca-nu-patient-healthcare-id
* Ontario - https://fhir.infoway-inforoute.ca/NamingSystem/ca-on-patient-hcn
* Prince Edward Island - https://fhir.infoway-inforoute.ca/NamingSystem/ca-pe-patient-healthcare-id
* Quebec - https://fhir.infoway-inforoute.ca/NamingSystem/ca-qc-patient-healthcare-id
* Saskatchewan - https://fhir.infoway-inforoute.ca/NamingSystem/ca-sk-patient-healthcare-id
* Yukon - https://fhir.infoway-inforoute.ca/NamingSystem/ca-yt-patient-healthcare-id

Following identifier types identify health card numbers issued in Canada to let a patient to be recognized for services and stay connected to related support programs:

* Canada Veteran's Affairs health card number - https://fhir.infoway-inforoute.ca/NamingSystem/ca-veterans-affairs-health-id
* Canada Correctional Service health card number - https://fhir.infoway-inforoute.ca/NamingSystem/ca-correctional-service-health-id
* Canada Royal Canadian Mounted Police (RCMP) health card number - https://fhir.infoway-inforoute.ca/NamingSystem/ca-royal-mounted-police-health-id
* Canada Armed Forces health card number - https://fhir.infoway-inforoute.ca/NamingSystem/ca-armed-forces-health-id

The full list of identifiers can be found on [Canadian URI Registry](https://simplifier.net/canadianuriregistry/~resources?category=NamingSystem). Canada Health Infoway provides Canadian URI Registry [search tool](https://fhir.infoway-inforoute.ca/nssearch) to simplify search.

**Version Code**

The [Version Code](https://build.fhir.org/ig/HL7-Canada/ca-baseline/extension-ext-identifierversion.html) extension is added to indicate the currency/validity of an identifier.

The rational is that the version code is current captured separately from the JHN because, in Ontario at least, the JHN is a stable identifier whereas the version code changes over time.

* The working assumption is that it is useful to have this stable identifier but not all of the Ontario specs reviewed stored it as a separate field. In one case, it appears to be an Patient.identifier.coding.value instead of the identifier …
* Example JHN and Patient Information from [Ontario Health Care Validation Reference Manual](http://www.health.gov.on.ca/english/providers/pub/ohip/ohipvalid_manual/ohipvalid_manual.pdf)
* Question: would specific examples like this be helpful to illustrate Canadian requirements?

**Example:**

```
{
  "type": {
    "coding": [
      {
        "system": "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code": "JHN"
      }
    ]
  },
  "system": "https://fhir.infoway-inforoute.ca/NamingSystem/ca-armed-forces-health-id",
  "value": "A98765439"
  }
}

```

## Patient Gender and Sex

Many systems and organizations only provide a single attribute to represent all aspects of a patient's gender and sex with a single value. However, there are many considerations around sex and gender documentation and interoperability.

The FHIR Specification provides [guidance](https://www.hl7.org/fhir/patient.html#gender) and background for representing patient gender.

In addition to that Canadian Patient profile defines following extensions:

* **Gender Identity** - an indication from the patient about what gender they consider themselves to be.
* **Sex assigned at Birth** - the sex assigned at birth, as documented on the birth registration.
* **Preferred Pronoun** - an indication from the patient about what pronoun to use in correspondence.

**!! TO BE COMPLETED !!**

## Telecom

A Patient may have multiple ways to be contacted with different uses or applicable periods. This Patient profile allows multiple contact points (e.g. a telephone number or an email address) by which the individual may be contacted.

To indicate the preferred way to contact use Patient.telecom.rank attribute (i.e., the [ContactPoint.rank](https://www.hl7.org/fhir/datatypes.html#contactpoint) component) that specifies a preferred order in which to use a set of contacts. ContactPoints with lower rank values are more preferred than those with higher rank values.

## Address

The Patient profile is provided for use in a Canadian context where some constraint on content is desirable to guarantee the quality of the Canadian address whilst still supporting other type of address (e.g., other countries or UNstructured addresses).

### Canadian postal code

If an address in the Patient resource instance represents Canadian address, it SHOULD follow Canadian postal code format.

The Canadian Postal Code SHOULD be a six-character uniformly structured uppercase alphanumeric code in the form of "ANA NAN", where "A" represents an alphabetic character and "N" represents a numeric character, with one space between the first three and the last three characters.

A hyphen SHOULD NOT be used (example of UNacceptable format: T0L-1K0).

### Preferred

The Patient.address MAY have a [Preferred](http://hl7.org/fhir/StructureDefinition/iso21090-preferred) extension. This is the FHIR standard defined extension used as a flag denoting whether parent address item is preferred.

### No Fixed Address

The Patient.address MAY have a [No Fixed Address](https://build.fhir.org/ig/HL7-Canada/ca-baseline/extension-ext-nofixedaddress.html) extension. This extension is to indicate that there is an assertion that there is no fixed address (e.g., homeless).

## Marital Status

The binding for the Patient.maritalStatus element is [extensible](https://www.hl7.org/fhir/terminologies.html#extensible) meaning that to be conformant, codes in this element SHALL be from the specified value set if any of the codes within the value set can apply to the concept being communicated.

Systems can send additional codes (Stats Canada, SNOMED CT, etc.) but can only do that if they also send the relevant HL7-assigned codes.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-patient",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
  "version" : "1.2.0",
  "name" : "PatientProfile",
  "title" : "Patient Profile",
  "status" : "draft",
  "date" : "2024-12-27",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the Patient Resource as scoped to human patients",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "short" : "Patient Profile",
        "definition" : "The Patient Profile is based upon the core FHIR Patient Resource",
        "isModifier" : false
      },
      {
        "id" : "Patient.extension",
        "path" : "Patient.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.extension:aboriginalidentitygroup",
        "path" : "Patient.extension",
        "sliceName" : "aboriginalidentitygroup",
        "short" : "Extension: Aboriginal Identity Group",
        "definition" : "A code classifying the person's aboriginal identity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-aboriginalidentitygroup"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Patient.extension:aboriginalidentityindicator",
        "path" : "Patient.extension",
        "sliceName" : "aboriginalidentityindicator",
        "short" : "Extension: Aboriginal Identity Indicator",
        "definition" : "A code classifying the person's self identity as an aboriginal person",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-aboriginalidentityindicator"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Patient.extension:birthsex",
        "path" : "Patient.extension",
        "sliceName" : "birthsex",
        "short" : "Extension: Sex at Birth",
        "definition" : "A code classifying the person's sex assigned at birth  as specified by the [TODO: assigning authority]. This extension aligns with the C-CDA Birth Sex Observation (LOINC 76689-9)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-patientbirthsex"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Patient.extension:ethnicity",
        "path" : "Patient.extension",
        "sliceName" : "ethnicity",
        "short" : "Extension: ethnicity extension",
        "definition" : "A code classifying the person's ethnic group or ethnicity as the category of people who identify with each other, usually on the basis of a presumed common genealogy or ancestry or on other similarities.",
        "comment" : "This attribute is based on the belief of the person or the person reporting the attribute, not on any formal analysis of genetic, geneological or historical relationships as these would need to be captured as observations.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-ethnicity"
            ]
          }
        ],
        "mustSupport" : false,
        "isModifier" : false,
        "mapping" : [
          {
            "identity" : "HL7v2",
            "map" : "PID.22 [Ethnic Group]",
            "comment" : "This field further defines the patient's ancestry.  Refer to User-defined Table 0189 - Ethnic Group in Chapter 2C, Code Tables, for suggested values."
          },
          {
            "identity" : "rim",
            "map" : "Person.ethnicGroupCode",
            "comment" : "A code classifying the person into a named category of humans sharing a common real or presumed heritage"
          },
          {
            "identity" : "CDA",
            "map" : "/ClinicalDocument/recordTarget/patientRole/patient/sdtc:ethnicGroupCode",
            "comment" : "This CDA R2 SDTC ethnicGroupCode extension is used to record additional ethnicity groups for the recordTarget or subjectPerson"
          }
        ]
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "type"
            }
          ],
          "rules" : "open"
        },
        "min" : 0,
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-identifier"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier.type",
        "path" : "Patient.identifier.type",
        "comment" : "The slice provided below is one example of an identifier type and has been socialized because of a Canadian extension on that identifier type. It is not required, and the slicing is open meaning that other types can be provided."
      },
      {
        "id" : "Patient.identifier.system",
        "path" : "Patient.identifier.system",
        "min" : 1,
        "isModifier" : false
      },
      {
        "id" : "Patient.identifier.value",
        "path" : "Patient.identifier.value",
        "short" : "The value that is unique within the system.",
        "min" : 1,
        "isModifier" : false
      },
      {
        "id" : "Patient.identifier:JHN",
        "path" : "Patient.identifier",
        "sliceName" : "JHN",
        "short" : "Jurisdictional Health Number",
        "definition" : "Federal patient and person health numbers used by all jurisdictions across Canada"
      },
      {
        "id" : "Patient.identifier:JHN.extension",
        "path" : "Patient.identifier.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.identifier:JHN.extension:versionCode",
        "path" : "Patient.identifier.extension",
        "sliceName" : "versionCode",
        "short" : "Health Number Version Code",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-identifierversion"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier:JHN.type",
        "path" : "Patient.identifier.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
              "code" : "JHN"
            }
          ]
        }
      },
      {
        "id" : "Patient.identifier:JHN.system",
        "path" : "Patient.identifier.system",
        "short" : "A Health Number Naming System from the Canadian URI Registry",
        "min" : 1
      },
      {
        "id" : "Patient.identifier:JHN.value",
        "path" : "Patient.identifier.value",
        "min" : 1
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "min" : 0,
        "constraint" : [
          {
            "key" : "ipa-pat-2",
            "severity" : "error",
            "human" : "Either Patient.name.given and/or Patient.name.family and/or Patient.name.text SHALL be present or a Data Absent Reason Extension SHALL be present.",
            "expression" : "(family.exists() or given.exists() or text.exists()) xor extension.where(url='http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "xpath" : "(/f:name/f:extension/@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason' and not(/f:name/f:family or /f:name/f:given or /f:name/f:text)) or (not(/f:name/f:extension/@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason') and (/f:name/f:family or /f:name/f:given or /f:name/f:text))"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.family",
        "path" : "Patient.name.family"
      },
      {
        "id" : "Patient.name.given",
        "path" : "Patient.name.given"
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom"
      },
      {
        "id" : "Patient.telecom.system",
        "path" : "Patient.telecom.system",
        "min" : 1
      },
      {
        "id" : "Patient.telecom.value",
        "path" : "Patient.telecom.value",
        "min" : 1
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "mustSupport" : true
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address"
      },
      {
        "id" : "Patient.address.extension",
        "path" : "Patient.address.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.address.extension:preferred",
        "path" : "Patient.address.extension",
        "sliceName" : "preferred",
        "short" : "HL7 Preferred Address Flag extension",
        "definition" : "Flag denoting whether parent address item is preferred",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/iso21090-preferred"]
          }
        ]
      },
      {
        "id" : "Patient.address.extension:noFixedAddress",
        "path" : "Patient.address.extension",
        "sliceName" : "noFixedAddress",
        "short" : "No Fixed Address indicator",
        "definition" : "Flag indicating that there is an assertion that there is no fixed address",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-nofixedaddress"
            ]
          }
        ]
      }
    ]
  }
}

```
