# OrganizationAffiliation Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **OrganizationAffiliation Profile**

## Resource Profile: OrganizationAffiliation Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organizationaffiliation | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:OrganizationAffiliationProfile |

 
Proposed constraints and extensions on the OrganizationAffiliation Resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. 

This profile was generated from [HL7 StructureDefinition](https://www.hl7.org/fhir/organizationaffiliation.profile.json) on 2019-03-28 and constrained during a review of US Core against Canadian sources.

**Note:** This profile has been added to meet requirements met by [ppr-ext-location-affiliation](https://simplifier.net/ProvincialProviderRe/location-affiliation/~json) extension used in the ON PPR guide.

**Intended use:**

* Resource Use 
* a Location is place
* an Organization is a group of people
* an Organization may have one or more location
 
* ppr-ext-location-affiliation was used to add an element to a ****Location**** used identify an affiliated organization, including: 
* .type ****of affiliation**** [ppr-provider-role-affiliation-type](https://simplifier.net/provincialproviderre/ppr-providerroleaffiliationtype)
* .period ****of affiliation****
* .with ****affiliated Organization****
 
* OrganizationAffiliation associates two Organizations and allows the location of the ParticipatingOrganization to be specified where: 
* OrganizationAffiliation.organization points to ****affiliated organization**** above
* OrganizationAffiliation.participationOrganization points to the ****Organization**** that performs a role (Location.managingOrganization)
* OrganizationAffiliation.code specifies the ****role**** the ****participatingOrganization**** plays (similar to Type above)
* OrganizationAffiliation.location points to the ****Location**** where the role is performed
 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-organizationaffiliation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-organizationaffiliation.csv), [Excel](StructureDefinition-profile-organizationaffiliation.xlsx), [Schematron](StructureDefinition-profile-organizationaffiliation.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-organizationaffiliation",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organizationaffiliation",
  "version" : "1.2.0",
  "name" : "OrganizationAffiliationProfile",
  "title" : "OrganizationAffiliation Profile",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the OrganizationAffiliation Resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "OrganizationAffiliation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/OrganizationAffiliation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "OrganizationAffiliation",
        "path" : "OrganizationAffiliation",
        "short" : "OrganizationAffiliation Profile",
        "definition" : "The OrganizationAffiliation Profile is based upon the core FHIR OrganizationAffiliation Resource"
      },
      {
        "id" : "OrganizationAffiliation.period",
        "path" : "OrganizationAffiliation.period"
      },
      {
        "id" : "OrganizationAffiliation.organization",
        "path" : "OrganizationAffiliation.organization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "OrganizationAffiliation.participatingOrganization",
        "path" : "OrganizationAffiliation.participatingOrganization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "OrganizationAffiliation.code",
        "path" : "OrganizationAffiliation.code",
        "binding" : {
          "strength" : "example",
          "description" : "The role the participating organization providing services to the primary organization.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/organization-role"
        }
      },
      {
        "id" : "OrganizationAffiliation.location",
        "path" : "OrganizationAffiliation.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-location"
            ]
          }
        ]
      }
    ]
  }
}

```
