# Observation Profile (Laboratory Results) - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Observation Profile (Laboratory Results)**

## Resource Profile: Observation Profile (Laboratory Results) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation-results | *Version*:1.2.0 |
| Draft as of 2024-12-27 | *Computable Name*:ObservationProfileLaboratory |

 
Proposed constraints on the Observation Resource to represent results produced by laboratory tests or panels/studies 

# CA Baseline Observation (Laboratory Results) Profile

> While this profile does not currently apply MS constraints on the hasMember, referenceRange, interpretation or component elements, this profile is seeking community and implementer feedback on how these elements are being used to assess whether consistent patterns can be identified for use in the Canadian landscape for certain types of test results (e.g., panel, antibody, blood tests, etc)
Feedback can be provided through the[Simplifier issue log for this profile](https://simplifier.net/CanadianFHIRBaselineProfilesCA-Core/ObservationProfileLaboratory/~issues).</p>

This Observation (Laboratory Results) profile further constrains the Observation (General Use) profile to represent results of laboratory tests.

This profile may represent a single value from a specific laboratory test (e.g. hematocrit) or it may represent a grouped set of results from a multi- test study or panel (e.g. complete blood count, urinalysis, electrolytes).

The Observation (Laboratory Results) profile reflects localization concepts in the Canadian context. 

## Mandatory Data Elements

All elements or attributes within the FHIR specification have cardinality as part of their definition - a minimum number of required appearances and a maximum number of allowable appearances.

Most elements in the FHIR specification have a minimum cardinality of **0**, so most elements are not required and subsequently they may be missing from a resource when it is exchanged between systems.

**Required elements:**

* status of the result value
* category to classify the general type of observation being made
* category: laboratory (mandatory child element of above)
* code to classify what was observed
* reference to a subject

Note: if Observation.component is provided then Observation.component.value is mandatory.

## Must Support Data Elements

Some elements are marked as Must Support. This means that implementations generating, receiving, or otherwise using resources with Must Support elements SHALL provide support for those elements in some meaningful way (see [Must Support](https://build.fhir.org/ig/HL7-Canada/ca-baseline/general-guidance.html#must-support) definition).

The following elements are marked as Must Support in the Observation (Laboratory Results) profile:

**Must Support elements:**

* category
* category:laboratory
* code
* reference to a subject
* effective date
* performer
* value
* component.code (if implementer supports component)
* component.value[x] (if implementer supports component)

### Data Absent Reason

If the minimum cardinality of an element or attribute is 1 AND information is missing AND the Responder knows the precise reason for the absence of data, then Responders SHOULD send the reason for the missing information using values from the valueset where it exists by using the [DataAbsentReason](http://hl7.org/fhir/StructureDefinition/data-absent-reason) extension.

An Observation without a value, SHOULD include a reason why the data is absent unless there are component observations, or references to other Observations that are grouped within it, i.e., unless there are component observations, or references to other Observations that are grouped within it then either ONE of **Observation.value** OR **Observation.dataAbsentReason** but NOT both should be present.

Note: The conformance language above was modified from SHALL to SHOULD to reflect the community decision to relax the invariant to account for Canadian implementations that have reason to not meet the rule given circumstances with R4 modeling for value expressions that is corrected in later versions of FHIR. At least one Canadian lab implementation uses an extension to communicate a result value in the form of a PDF (which R4 does not support under its existing value data types).

## Usage Note

Observation (Laboratory Results) is intended to represent results of laboratory tests and studies. This profile constrains the Observation (General Use) resource to represent laboratory results in messages and patient summaries if no other, more specific profile is more appropriate.

The following list of examples is intended to represent some examples of typical use cases and is not exhaustive:

* complete blood count
* prothrombin time
* basic metabolic panel
* comprehensive metabolic panel
* lipid panel
* liver panel
* thyroid stimulating hormone
* hemoglobin a1c
* culture and sensitivity

including the interpretations and reference ranges associated with the result(s).

Observation (Laboratory Results) should not be used if one of the following profiles is applicable: (to be completed later)

**Usages:**

* Refer to this Profile: [DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-profile-diagnosticreport.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-observation-results)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-observation-results.csv), [Excel](StructureDefinition-profile-observation-results.xlsx), [Schematron](StructureDefinition-profile-observation-results.sch) 

### Notes:

## Using codes in Observation

Additional codes that translate or map to the Observation code or category codes are allowed (see [CodeableConcept](http://hl7.org/fhir/R4/datatypes.html#CodeableConcept) data type). For example: providing both a local code and LOINC code providing a more specific category codes, SNOMED CT concept, or system specific codes.

## Category

The **Observation.category** specifies a code that classifies the general type of observation being made. The **Observation.category** element is [CodeableConcept](http://hl7.org/fhir/R4/datatypes.html#CodeableConcept) data type and more than one code is allowed. For interoperability reason one of the codes SHOULD be from the FHIR standard defined [Observation Category Codes](https://www.hl7.org/fhir/valueset-observation-category.html). Local codes are allowed as well. In case of using local codes to better classify the type both **category.coding.system** and **category.coding.code** SHOULD be provided.

## Code

The Observation.code element describes what was observed. Sometimes this is called the observation "name".

The [pan-Canadian LOINC Observation Code Database (pCLOCD)](https://infocentral.infoway-inforoute.ca/en/standards/canadian/pclocd-loinc) is recommended for use in a Canadian context. Code System URI is https://fhir.infoway-inforoute.ca/CodeSystem/pCLOCD

## value[x]

If the result value is a code:

* both **valueCodeableConcept.coding.system** and **valueCodeableConcept.coding.code** SHALL be present
* a code from [SNOMED CT](http://www.snomed.org) SHOULD be used
* additional codes that translate or map Observation code or category codes are allowed

If the result value is a numeric quantity:

* **valueQuantity.value** , **valueQuantity.unit** and **valueQuantity.sytem** SHALL be present
* a standard [UCUM](http://unitsofmeasure.org) unit SHALL be used.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-observation-results",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation-results",
  "version" : "1.2.0",
  "name" : "ObservationProfileLaboratory",
  "title" : "Observation Profile (Laboratory Results)",
  "status" : "draft",
  "date" : "2024-12-27",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints on the Observation Resource to represent results produced by laboratory tests or panels/studies",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Observation Profile",
        "definition" : "The Observation Profile is based upon the core FHIR Observation Resource",
        "constraint" : [
          {
            "key" : "ca-baseline-results-1",
            "severity" : "warning",
            "human" : "SHOULD use SNOMED CT for coded Results",
            "expression" : "(component.value | value).ofType(Quantity).all(system = 'http://unitsofmeasure.org')"
          }
        ]
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "comment" : "Statuses are fundamental to understanding lab domain results. This element is considered mandatory and is a modifier element in the base specification. This profile is seeking community and implementer feedback on whether the MustSupport flag that has been reintroduced in this profile elicits further challenges to systems.",
        "mustSupport" : true
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.category:laboratory",
        "path" : "Observation.category",
        "sliceName" : "laboratory",
        "short" : "FHIR standard classification of type of observation",
        "comment" : "This profile is scoped to an event (results) which includes constraints for that event. Profiles such as the OLIS Lab Observation Profile may be scoped more broadly to include modelling for more than just a single results step in the workflow. Both forms of modelling are appopriate, however implementers should be aware of the impact of scope on the setting of constraints (like this slice) and agknowledge that if their own profile is different in scope than the CA Baseline profile, it is not expected that they meet all the constraints outlined in this profile and it may be appropriate to review the generic observation profile instead.",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "laboratory"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "comment" : "The binding strength of this element is [Preferred](https://www.hl7.org/fhir/terminologies.html#strength), meaning that codes are encouraged to draw from the LOINC or PCLOCD code system for interoperability purposes but are not required to do so to be considered conformant. *All* code-value and, if present, component.code-component.value pairs need to be taken into account to correctly understand the meaning of the observation.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "description" : "LOINC codes identifying names of simple observations.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-codes"
        }
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.org/fhir/StructureDefinition/Location"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "type" : [
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ],
        "constraint" : [
          {
            "key" : "ca-baseline-datetime",
            "severity" : "error",
            "human" : "Datetime SHALL be at least to day",
            "expression" : "($this as dateTime).toString().length() >= 8"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.issued",
        "path" : "Observation.issued",
        "comment" : "Implementors should consider adding a must support flag in the case that the relevant systems are not able to support effective, but are able to support issued."
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]:valueCodeableConcept",
        "path" : "Observation.value[x]",
        "sliceName" : "valueCodeableConcept",
        "comment" : "A coded value **SHOULD**  be selected from [SNOMED CT](http://www.snomed.org).",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Observation.value[x]:valueCodeableConcept.coding",
        "path" : "Observation.value[x].coding"
      },
      {
        "id" : "Observation.value[x]:valueCodeableConcept.coding.system",
        "path" : "Observation.value[x].coding.system",
        "short" : "FHIR standard classification of type of observation code system",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.value[x]:valueCodeableConcept.coding.code",
        "path" : "Observation.value[x].coding.code",
        "short" : "A code difining laboratory result",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.value[x]:valueQuantity",
        "path" : "Observation.value[x]",
        "sliceName" : "valueQuantity",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.value[x]:valueQuantity.value",
        "path" : "Observation.value[x].value",
        "min" : 1
      },
      {
        "id" : "Observation.value[x]:valueQuantity.system",
        "path" : "Observation.value[x].system"
      },
      {
        "id" : "Observation.dataAbsentReason",
        "path" : "Observation.dataAbsentReason",
        "comment" : "This element is recommended for support and was initially flagged as must support but was later determined to be too strong for some types of lab result profiles that want to derive from the CA Baseline but do not need a dataAbsentReason concept"
      },
      {
        "id" : "Observation.interpretation",
        "path" : "Observation.interpretation",
        "comment" : "This element is recommended for support and was initially flagged as must support but was later determined to be too strong for some types of lab result profiles (e.g., antibody results, blood typing results, etc.) that want to derive from the CA Baseline but do not have an interpretation concept (e.g., norm/abnormal, high/low)."
      },
      {
        "id" : "Observation.referenceRange",
        "path" : "Observation.referenceRange",
        "comment" : "This element is recommended for support and was initially flagged as must support but was later determined to be too strong for some types of lab result profiles (e.g., labs with non-numeric results) that want to derive from the CA Baseline but do not have a need for a numeric reference range concept."
      },
      {
        "id" : "Observation.hasMember",
        "path" : "Observation.hasMember",
        "comment" : "This element was initially flagged as must support but was later determined to be too strong for some types of lab result profile that want to derive from the CA Baseline but do not have a use hasMember to link results. Examples of these include but are not limited to non-panel results and panel result implementations that use alternative methods like ServiceRequest or DiagnosticReport to link panel results together."
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "comment" : "Some elements underneath this backbone element are considered must support. This does not incur the expectation to support these elements for any implementers that do not need to support the parent concept of observation.component. This may need to be evaluated in the future as impelementations seek to derive directly from the CA Baseline profiles"
      },
      {
        "id" : "Observation.component.code",
        "path" : "Observation.component.code",
        "comment" : "The binding strength of this element is [Preferred](https://www.hl7.org/fhir/terminologies.html#strength), meaning that codes are encouraged to draw from the LOINC code system for interoperability purposes but are not required to do so to be considered conformant. *All* code-value and, if present, component.code-component.value pairs need to be taken into account to correctly understand the meaning of the observation.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "description" : "LOINC codes identifying names of simple observations.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-codes"
        }
      },
      {
        "id" : "Observation.component.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.component.value[x]:valueCodeableConcept",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueCodeableConcept",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Observation.component.value[x]:valueCodeableConcept.coding",
        "path" : "Observation.component.value[x].coding",
        "short" : "FHIR standard classification of type of observation code system",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component.value[x]:valueCodeableConcept.coding.system",
        "path" : "Observation.component.value[x].coding.system",
        "short" : "FHIR standard classification of type of observation code system",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.component.value[x]:valueCodeableConcept.coding.code",
        "path" : "Observation.component.value[x].coding.code",
        "short" : "A code defining laboratory result",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.component.value[x]:valueQuantity",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueQuantity",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.component.value[x]:valueQuantity.value",
        "path" : "Observation.component.value[x].value",
        "min" : 1
      },
      {
        "id" : "Observation.component.value[x]:valueQuantity.system",
        "path" : "Observation.component.value[x].system"
      },
      {
        "id" : "Observation.component.dataAbsentReason",
        "path" : "Observation.component.dataAbsentReason"
      }
    ]
  }
}

```
