# MedicationStatement Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **MedicationStatement Profile**

## Resource Profile: MedicationStatement Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationstatement | *Version*:1.2.0 |
| Draft as of 2024-12-13 | *Computable Name*:MedicationStatementProfile |

 
Proposed constraints and extensions on the MedicationStatement resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. 

This profile was generated from [HL7 StructureDefinition](https://www.hl7.org/fhir/medicationstatement.profile.json) on 2019-03-28 and constrained during a review of US Core against Canadian sources.

Key differences from [USCoreR4 MedicationStatement](https://build.fhir.org/ig/HL7/US-Core-R4/StructureDefinition-us-core-medicationstatement.html):

* MedicationStatement.medication updated: 
* CodeableConcept binding to ValueSet-prescriptionmedicinalproduct
* Reference to profile-medication
 
* MedicationStatement.subject reference updated to profile-patient

**Usages:**

* Refer to this Profile: [MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-medicationstatement)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-medicationstatement.csv), [Excel](StructureDefinition-profile-medicationstatement.xlsx), [Schematron](StructureDefinition-profile-medicationstatement.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-medicationstatement",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationstatement",
  "version" : "1.2.0",
  "name" : "MedicationStatementProfile",
  "title" : "MedicationStatement Profile",
  "status" : "draft",
  "date" : "2024-12-13",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the MedicationStatement resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationStatement",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationStatement",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationStatement",
        "path" : "MedicationStatement",
        "short" : "MedicationStatement Profile",
        "definition" : "The MedicationStatement Profile is based upon the core FHIR MedicationStatement Resource"
      },
      {
        "id" : "MedicationStatement.basedOn",
        "path" : "MedicationStatement.basedOn",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationrequest",
              "http://hl7.org/fhir/StructureDefinition/CarePlan",
              "http://hl7.org/fhir/StructureDefinition/ServiceRequest"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.partOf",
        "path" : "MedicationStatement.partOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationadministration",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationdispense",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationstatement",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-procedure",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.status",
        "path" : "MedicationStatement.status",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.medication[x]",
        "path" : "MedicationStatement.medication[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medication"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "description" : "TBD. This is a placeholder for a comprehensive valueset, consisting of all Manufactured Product (MP), Non-proprietary Therapeutic Product (NTP) and Therapeutic Moiety (TM) codes, which would be created and maintained by Canada Health Infoway. Medicinal products for prescribing and dispensing in Canada. The content of this subset only contains commonly used medicinal products that are available for prescribing and dispensing in Canada. This content will expand to include all human medicinal products over time.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/prescriptionmedicinalproduct"
        }
      },
      {
        "id" : "MedicationStatement.subject",
        "path" : "MedicationStatement.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.context",
        "path" : "MedicationStatement.context",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-encounter",
              "http://hl7.org/fhir/StructureDefinition/EpisodeOfCare"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.effective[x]",
        "path" : "MedicationStatement.effective[x]",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.informationSource",
        "path" : "MedicationStatement.informationSource",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.derivedFrom",
        "path" : "MedicationStatement.derivedFrom",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationrequest",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medicationdispense",
              "http://hl7.org/fhir/StructureDefinition/Claim",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation",
              "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.reasonReference",
        "path" : "MedicationStatement.reasonReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-condition",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-diagnosticreport",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-diagnosticreportnote"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.dosage",
        "path" : "MedicationStatement.dosage",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.dosage.text",
        "path" : "MedicationStatement.dosage.text",
        "mustSupport" : true
      }
    ]
  }
}

```
