# Medication Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Medication Profile**

## Resource Profile: Medication Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medication | *Version*:1.2.0 |
| Draft as of 2024-12-27 | *Computable Name*:MedicationProfile |

 
Proposed constraints and extensions on the Medication resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. 

This profile was generated from [HL7 StructureDefinition](https://www.hl7.org/fhir/medication.profile.json) on 2019-03-28 and constrained during a review of US Core against Canadian sources. RxNorm is not used in Canada and the list of medicinal products available differs from the US, therefore [PrescribeIT Medication Profile](https://specs.prescribeit.ca/R2.0/erx/profile-medication.html) was used as a basis for this profile - with some significant differences due to structural differences between versions of FHIR.

Key differences from [USCoreR4 Medication](https://build.fhir.org/ig/HL7/US-Core-R4/StructureDefinition-us-core-medication.html):

* RxNorm is not used in Canada, replaced with a Canadian list of MedicationForm

Key differences from [PrescribeIT Medication Profile](https://specs.prescribeit.ca/R2.0/erx/profile-medication.html):

* Medication.id left with FHIR defaults
* Medication.product element has been deleted from FHIR, used Medication.form, Medication.ingredient, Medication.amount instead of equiv. elements in Medication.product

**Note:**

* medicationStrength, isRepresentative, and isActive extensions socialized in this profile and come from the PrescribeIT 2.0 specification
* Medication.ingredient.item[x] is currently restricted in a manner consistent with the PrescribeIT Medication profile. **« Question for Implementors: Is this preferable to providing references to other Medication (and potentially Substance) resources?**
* [ON DHDR](https://simplifier.net/ontariodigitalhealth/medication) and [HL7 v3 AdministerableMedicine](https://infocentral.infoway-inforoute.ca/extra/ca/mr0206-html/html/message.html?COCT_MT220200CA) appear to approach similar things differently than below.

**Usages:**

* Refer to this Profile: [MedicationAdministration Profile](StructureDefinition-profile-medicationadministration.md), [MedicationDispense Profile](StructureDefinition-profile-medicationdispense.md), [MedicationRequest Profile](StructureDefinition-profile-medicationrequest.md), [MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md) and [Procedure Profile](StructureDefinition-profile-procedure.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-medication)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-medication.csv), [Excel](StructureDefinition-profile-medication.xlsx), [Schematron](StructureDefinition-profile-medication.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-medication",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-medication",
  "version" : "1.2.0",
  "name" : "MedicationProfile",
  "title" : "Medication Profile",
  "status" : "draft",
  "date" : "2024-12-27",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the Medication resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Medication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Medication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Medication",
        "path" : "Medication",
        "short" : "Medication Profile",
        "definition" : "The Medication Profile is based upon the core FHIR Medication Resource"
      },
      {
        "id" : "Medication.extension",
        "path" : "Medication.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Medication.extension:medicationstrength",
        "path" : "Medication.extension",
        "sliceName" : "medicationstrength",
        "short" : "Socialized Optional Extension: Medication Strength",
        "definition" : "Provides a textual description of the strength of the active ingredient(s) in the medication",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://prescribeit.ca/fhir/StructureDefinition/ext-medication-strength-description"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Medication.code",
        "path" : "Medication.code",
        "comment" : "Given the lack of an existing superset of Canadian codes and the complexity and variation in code systems used by of prescription ordering and medication & natural product dispensing systems - The Canadian Baseline has chosen to model the variety of coding systems expected in existing systems through an open slice on code.coding. When a super value set is developed, the CA Baseline will update the preferred binding strength that currently points to a placeholder to align to the new value set.",
        "min" : 1,
        "example" : [
          {
            "label" : "DIN",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/NamingSystem/ca-hc-din"
                }
              ]
            }
          },
          {
            "label" : "NPN",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-hc-npn"
                }
              ]
            }
          },
          {
            "label" : "CCDD",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/hc-CCDD"
                }
              ]
            }
          },
          {
            "label" : "SNOMED CT (Medications) - IPS",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct"
                }
              ]
            }
          },
          {
            "label" : "WHO ATC IPS",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://www.whocc.no/atc"
                }
              ]
            }
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "description" : "TBD. This is a placeholder for a comprehensive valueset, consisting of all Manufactured Product (MP), Non-proprietary Therapeutic Product (NTP) and Therapeutic Moiety (TM) codes, which would be created and maintained by Canada Health Infoway. Medicinal products for prescribing and dispensing in Canada. The content of this subset only contains commonly used medicinal products that are available for prescribing and dispensing in Canada. This content will expand to include all human medicinal products over time.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/prescriptionmedicinalproduct"
        }
      },
      {
        "id" : "Medication.code.extension",
        "path" : "Medication.code.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Medication.code.coding",
        "path" : "Medication.code.coding",
        "comment" : "CA Baseline Usage Notes: either text or at least one coding or both have to be present",
        "mustSupport" : true
      },
      {
        "id" : "Medication.code.coding.extension:isRepresentative",
        "path" : "Medication.code.coding.extension",
        "sliceName" : "isRepresentative",
        "short" : "Socialized Optional Extension: Code is Representative",
        "definition" : "If set to true, indicates that the medication code sent was chosen as a representative code of a drug picked at a more general level. I.e. The user didn't actually choose this specific code. The intended constraints around what drug should be supplied are conveyed by the request's substitution rules.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://prescribeit.ca/fhir/StructureDefinition/ext-medication-code-representative"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Medication.code.coding.system",
        "path" : "Medication.code.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Medication.code.coding.code",
        "path" : "Medication.code.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Medication.code.text",
        "path" : "Medication.code.text",
        "comment" : "CA Baseline Usage Notes: either text or at least one coding or both have to be present",
        "mustSupport" : true
      },
      {
        "id" : "Medication.manufacturer",
        "path" : "Medication.manufacturer",
        "comment" : "CA Baseline Usage Notes: This is a reference to an organization that manufactures the medication. TBD: if there is a need to refernce a 'DPD Company', a new extension should be created and used. A 'DPD Company' name, as used in the Health Canada DPF, indicates the organisation (company) that holds the authorization to place the product on the market in Canada. This may not be the company that has manufactured the product, but it is the company that holds the legal responsibility for the use of the product in Canada and should be the same as the company named on the product label/packaging.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "Medication.form",
        "path" : "Medication.form",
        "comment" : "CA Core Usage Notes: The prescription drug form is required in some provinces in order to meet the prescribing standards set out by the College of Physicians and Surgeons.",
        "binding" : {
          "strength" : "example",
          "description" : "TBD. This is a placeholder for a comprehensive valueset, which would be created and maintained by Canada Health Infoway. Currently seeking implementer feedback and input from pan-Canadian profiles to support updates to the nominated valueSet.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/dispensabledrugform"
        }
      }
    ]
  }
}

```
