# Location Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Location Profile**

## Resource Profile: Location Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-location | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:LocationProfile |

 
Proposed constraints and extensions on the Location resource 

# CA Baseline Location Profile

This Location profile sets minimum expectations for the Location resource to record, search and fetch details and position information for a physical place where services are provided.

This profile defines localization concepts for use in a Canadian context.

## Mandatory Data Elements

All elements or attributes defined in FHIR have cardinality as part of their definition - a minimum number of required appearances and a maximum number.

Most elements in FHIR specification have a minimum cardinality of 0, which means that they may be missing from a resource when it is exchanged between systems.

In this Canadian Baseline Location Profile all elements are optional, i.e., there is no element with a minimum cardinality of 1. However, some optional elements (e.g., identifier) have required components that MUST be present if that optional element is provided.

## Must Support Data Elements

Some elements are labeled as MustSupport meaning that implementations that produce or consume resources SHALL provide "support" for the element in some meaningful way (see [Must Support](https://build.fhir.org/ig/HL7-Canada/ca-baseline/general-guidance.html#must-support) definition).

Following elements are marked as Must Support in the Canadian Location profile to aid record matching in databases with many pediatric records.

**Must Support elements:**

* an identifier
* a location name
* contact detail (e.g. a telephone number or an email address)

**Usages:**

* Refer to this Profile: [DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-profile-diagnosticreport.md), [Encounter Profile](StructureDefinition-profile-encounter.md), [Immunization Profile](StructureDefinition-profile-immunization.md), [MedicationDispense Profile](StructureDefinition-profile-medicationdispense.md)...Show 3 more,[OrganizationAffiliation Profile](StructureDefinition-profile-organizationaffiliation.md),[Procedure Profile](StructureDefinition-profile-procedure.md)and[ServiceRequest Profile for Results Reporting](StructureDefinition-profile-servicerequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-location)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-location.csv), [Excel](StructureDefinition-profile-location.xlsx), [Schematron](StructureDefinition-profile-location.sch) 

### Notes:

## Identifiers

Currently, there is no consensus or requirement for pan-Canadian method to identify a location using a business identifier. Location.identifier will remain unsliced until a requirement or rationale is put forth that supports the need to have unique constraints determined by the business identifier.

## Service Language

The Location MAY have a [Service Language](http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-servicelanguage) extension. This extension is to identify languages that that services are provided in this particular location.

## Address

The Location profile is provided for use in a Canadian context where some constraint on content is desirable to guarantee the quality of the Canadian address whilst still supporting other type of address (e.g., other countries or UNstructured addresses).

### Canadian postal code

If an address in the Location resource instance represents Canadian address, it SHOULD follow Canadian postal code format.

The Canadian Postal Code SHOULD be a six-character uniformly structured uppercase alphanumeric code in the form of "ANA NAN", where "A" represents an alphabetic character and "N" represents a numeric character, with one space between the first three and the last three characters.

A hyphen SHOULD NOT be used (example of UNacceptable format: T0L-1K0).



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-location",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-location",
  "version" : "1.2.0",
  "name" : "LocationProfile",
  "title" : "Location Profile",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the Location resource",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Location",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Location",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Location",
        "path" : "Location"
      },
      {
        "id" : "Location.extension:communication",
        "path" : "Location.extension",
        "sliceName" : "communication",
        "short" : "Languages used to provide services",
        "definition" : "Indentifies languages that services are provided in at the location.",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-servicelanguage"
            ]
          }
        ],
        "mustSupport" : false,
        "isModifier" : false
      },
      {
        "id" : "Location.identifier",
        "path" : "Location.identifier",
        "mustSupport" : true
      },
      {
        "id" : "Location.name",
        "path" : "Location.name",
        "mustSupport" : true
      },
      {
        "id" : "Location.telecom",
        "path" : "Location.telecom",
        "mustSupport" : true
      },
      {
        "id" : "Location.address",
        "path" : "Location.address"
      }
    ]
  }
}

```
