# Immunization Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Immunization Profile**

## Resource Profile: Immunization Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-immunization | *Version*:1.2.0 |
| Draft as of 2024-12-27 | *Computable Name*:ImmunizationProfile |

 
Proposed constraints and extensions on the Immunization resource. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. 

This profile was generated from [HL7 StructureDefinition](https://www.hl7.org/fhir/immunization.profile.json) on 2019-03-28 and constrained during a review of US Core against Canadian sources.

**Note** The USCoreR4 resource supports recording of vaccines not given (refused) with reasons. The [Ontario Immunization Connect (ICON) profiles](https://simplifier.net/digitalhealthimmuniz/~resources?category=Profile&sortBy=RankScore_desc) has fixed values for Immunization.status and Immunization.notGiven that restrict use to completed vaccinations. **« As in USCoreR4, refused vaccines are supported in this profile.**

Key differences from [USCoreR4 Immunization](https://build.fhir.org/ig/HL7/US-Core-R4/StructureDefinition-us-core-immunization.html):

* Immunization.code bound to ValueSet with Canadian vaccine codes
* Immunization.patient reference changed to profile-patient
* Immunization.occurrenceDateTime:estimated extension added to identify estimated dates to be more consistent with ICON and CDN HL7v3 specs
* included other Immunization resource elements used in the ICON spec for visibility

**Usages:**

* Refer to this Profile: [ImmunizationRecommendation Profile](StructureDefinition-profile-immunizationrecommendation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-immunization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-immunization.csv), [Excel](StructureDefinition-profile-immunization.xlsx), [Schematron](StructureDefinition-profile-immunization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-immunization",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-immunization",
  "version" : "1.2.0",
  "name" : "ImmunizationProfile",
  "title" : "Immunization Profile",
  "status" : "draft",
  "date" : "2024-12-27",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the Immunization resource.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Immunization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Immunization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Immunization",
        "path" : "Immunization"
      },
      {
        "id" : "Immunization.status",
        "path" : "Immunization.status",
        "mustSupport" : true
      },
      {
        "id" : "Immunization.statusReason",
        "path" : "Immunization.statusReason",
        "comment" : "CA Baseline Usage Notes: a reason should be provided if the status is \"not-done\"."
      },
      {
        "id" : "Immunization.vaccineCode",
        "path" : "Immunization.vaccineCode",
        "mustSupport" : true
      },
      {
        "id" : "Immunization.vaccineCode.coding",
        "path" : "Immunization.vaccineCode.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "system"
            },
            {
              "type" : "pattern",
              "path" : "code"
            }
          ],
          "rules" : "open"
        },
        "comment" : "CA Baseline Usage Notes: for immunization submission, a server should accept any code a client is able to provide: a Generic code, a Tradename code or both. For immunization retireval, a Trade name is optional, but a Generic code has to be returned if it's known to the server or if it can be derived from the Tradename code. Supply of codings is preferred, however legacy, emergency vaccines, and recall use cases may present challenges to requiring codings. It is at the discretion of the implementer to strengthen the requirement further based on their needs and business context (e.g., requiring coding on all immunization records in their repository)."
      },
      {
        "id" : "Immunization.vaccineCode.coding:Generic",
        "path" : "Immunization.vaccineCode.coding",
        "sliceName" : "Generic",
        "comment" : "CA Baseline Usage Notes: either a Generic code or a Tradename code or both have to be present.",
        "max" : "1",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://cvc.canimmunize.ca/v3/ValueSet/Generic"
        }
      },
      {
        "id" : "Immunization.vaccineCode.coding:Tradename",
        "path" : "Immunization.vaccineCode.coding",
        "sliceName" : "Tradename",
        "comment" : "CA Baseline Usage Notes: either a Generic code or a Tradename code or both have to be present.",
        "max" : "1",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://cvc.canimmunize.ca/v3/ValueSet/Tradename"
        }
      },
      {
        "id" : "Immunization.patient",
        "path" : "Immunization.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Immunization.encounter",
        "path" : "Immunization.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-encounter"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.occurrence[x]",
        "path" : "Immunization.occurrence[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "closed"
        },
        "short" : "Vaccine administration date",
        "definition" : "Date vaccine administered or was to be administered.",
        "comment" : "CA Baseline Usage Notes: While occurrenceString is allowed given its use in existing Canadian systems - a combination of occurrenceDateTime (full or partial) with the 'estimated' extension is the preferred mechanism for expressing when an exact date is unknown. For example, if a patient recalls that they were immunized in June 1980, occurrenceDateTime will have a partial date '1980-06' with 'estimated'=true. Another example: if in 2020, a 55 y.o. patient recalls that they were immunized at the age of 5, occurrenceDateTime will have a partial date '1970' with 'estimated'=true.",
        "min" : 1,
        "max" : "1",
        "base" : {
          "path" : "Immunization.occurrence[x]",
          "min" : 1,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "dateTime"
          },
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Immunization.occurrence[x]:occurrenceDateTime",
        "path" : "Immunization.occurrence[x]",
        "sliceName" : "occurrenceDateTime",
        "short" : "Vaccine administration date",
        "definition" : "Date vaccine administered or was to be administered.",
        "comment" : "When immunizations are given a specific date and time should always be known.   When immunizations are patient reported, a specific date might not be known.  Although partial dates are allowed, an adult patient might not be able to recall the year a childhood immunization was given. An exact date is always preferable, but the use of the String data type is acceptable when an exact date is not known. A small number of vaccines (e.g. live oral typhoid vaccine) are given as a series of patient self-administered dose over a span of time. In cases like this, often, only the first dose (typically a provider supervised dose) is recorded with the occurrence indicating the date/time of the first dose.",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "Immunization.occurrence[x]",
          "min" : 1,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Immunization.occurrence[x]:occurrenceDateTime.extension",
        "path" : "Immunization.occurrence[x].extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 0,
        "max" : "*",
        "base" : {
          "path" : "Element.extension",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "Extension"
          }
        ]
      },
      {
        "id" : "Immunization.occurrence[x]:occurrenceDateTime.extension:estimated",
        "path" : "Immunization.occurrence[x].extension",
        "sliceName" : "estimated",
        "max" : "1",
        "base" : {
          "path" : "Element.extension",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-dateestimated"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Immunization.primarySource",
        "path" : "Immunization.primarySource",
        "short" : "Indicates that data is from the primary record created at the time the vaccine was administered."
      },
      {
        "id" : "Immunization.reportOrigin",
        "path" : "Immunization.reportOrigin",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://cvc.canimmunize.ca/v3/ValueSet/RepSource"
        }
      },
      {
        "id" : "Immunization.location",
        "path" : "Immunization.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-location"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.manufacturer",
        "path" : "Immunization.manufacturer",
        "comment" : "CA Baseline Usage Notes: This is a reference to an organization that manufactures the vaccine. TBD: if there is a need to refernce a 'DPD Company', a new extension should be created and used. A 'DPD Company' name, as used in the Health Canada DPF, indicates the organisation (company) that holds the authorization to place the product on the market in Canada. This may not be the company that has manufactured the product, but it is the company that holds the legal responsibility for the use of the product in Canada and should be the same as the company named on the product label/packaging.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.site",
        "path" : "Immunization.site",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://cvc.canimmunize.ca/v3/ValueSet/AnatomicalSite"
        }
      },
      {
        "id" : "Immunization.route",
        "path" : "Immunization.route",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://cvc.canimmunize.ca/v3/ValueSet/RouteOfAdmin"
        }
      },
      {
        "id" : "Immunization.performer.actor",
        "path" : "Immunization.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.reasonReference",
        "path" : "Immunization.reasonReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-condition",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-diagnosticreport",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-diagnosticreportnote"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.reaction.detail",
        "path" : "Immunization.reaction.detail",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.protocolApplied.authority",
        "path" : "Immunization.protocolApplied.authority",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.protocolApplied.targetDisease",
        "path" : "Immunization.protocolApplied.targetDisease",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://cvc.canimmunize.ca/v3/ValueSet/Disease"
        }
      }
    ]
  }
}

```
