# Encounter Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Encounter Profile**

## Resource Profile: Encounter Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-encounter | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:EncounterProfile |

 
Proposed constraints and extensions on the Encounter Resource 

# CA Baseline Encounter Profile

This profile sets minimum expectations for the Encounter resource to represent various observations if no other, more specific profile is applicable.

This Encounter profile represents an interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient, or to communicate information on a visit-specific basis.

This profile defines localization concepts for use in the Canadian context.

## Mandatory Data Elements

All elements or attributes within the FHIR specification have cardinality as part of their definition - a minimum number of required appearances and a maximum number of allowable appearances.

Most elements in the FHIR specification have a minimum cardinality of 0, so most elements are not required and subsequently they may be missing from a resource when it is exchanged between systems.

**Required elements in the Encounter profile:**

* state of the encounter (Encounter.status)
* classification of the encounter (Encounter.class)
* subject of the encounter (Encounter.subject)

## Must Support Data Elements

Some elements are marked as Must Support. This means that implementations generating, receiving, or otherwise using resources with Must Support elements SHALL provide support for those elements in some meaningful way (see [Must Support](https://build.fhir.org/ig/HL7-Canada/ca-baseline/general-guidance.html#cardinality-and-mustsupport-definitions) definition).

The following elements are marked as Must Support in the Encounter profile:

**Must Support elements:**

* identifier
* state of the encounter (Encounter.status)
* classification of the encounter (Encounter.class)
* reference to a subject (Encounter.subject)
* responsible providers (Encounter.participant)
* reasons (Encounter.reasonCode)
* diagnosis relevant to the encounter (Encounter.diagnosis)
* diagnosis rank
* admission details (Encounter.hospitalization)

## Usage Note

It is anticipated that many systems only need the current information of the encounter and therefore the Encounter resource represents the most recent information.

Systems that need to track historical information about the encounter should be able to do that by increasing complexity of the Encounter resource instance.

**Usages:**

* Refer to this Profile: [AllergyIntolerance Profile](StructureDefinition-profile-allergyintolerance.md), [Condition Profile](StructureDefinition-profile-condition.md), [DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-profile-diagnosticreport.md), [Diagnostic Report for Report and Note Exchange Profile](StructureDefinition-profile-diagnosticreportnote.md)...Show 9 more,[DocumentReference Profile for metadata about the document](StructureDefinition-profile-documentreference.md),[Encounter Profile](StructureDefinition-profile-encounter.md),[Immunization Profile](StructureDefinition-profile-immunization.md),[MedicationAdministration Profile](StructureDefinition-profile-medicationadministration.md),[MedicationDispense Profile](StructureDefinition-profile-medicationdispense.md),[MedicationRequest Profile](StructureDefinition-profile-medicationrequest.md),[MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md),[Procedure Profile](StructureDefinition-profile-procedure.md)and[ServiceRequest Profile for Results Reporting](StructureDefinition-profile-servicerequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-encounter)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-encounter.csv), [Excel](StructureDefinition-profile-encounter.xlsx), [Schematron](StructureDefinition-profile-encounter.sch) 

### Notes:

## Class

The **Encounter.class** element is to provide the kind of stay that a subject is having. This is different than the **Encounter.type** that explains what is done to the subject within this encounter.

In other words, the **Encounter.class** identifies the setting for the encounter (inpatient/outpatient) in which the encounter took place.

Since it is important for interpreting the context of the encounter, for choosing the appropriate business rules to enforce the clinical/management process, this element is required (cardinality 1..1) and marked as Must Support.

The **Encounter.class** element does NOT identify the priority of the encounter (see **Encounter.priority**). Therefore `Encounter.class = "EMER"` (Emergency) refers to an encounter happening at a dedicated healthcare service delivery location (e.g., Emergency Department) rather than the priority of the encounter.

## Type

The **Encounter.type** element is to provide a specific code indicating type of service provided.

This element is bound to [EncounterType](http://build.fhir.org/ig/HL7-Canada/ca-baseline/branches/master/ValueSet-encountertype.html) value set which includes codes from [SNOMED CT](http://www.snomed.org) decending from the 308335008 (Patient encounter procedure (procedure)) concept.

To extract all descendant of the [SNOMED CT](http://www.snomed.org) concept 308335008 use an ECL expression `<< 308335008`.

```
- ISSUE #143: Need to better define the value set for the Encounter.type and explain the difference between Encounter.type and Encounter.serviceType based on use cases. 
- Possible value sets:
- descendant of the SNOMED CT concept 308335008 | Patient encounter procedure (procedure);
- descendant of the SNOMED CT concept 308467007 | Seen in establishment (finding)
- descendant of the SNOMED CT concept 308930007 | Seen by health professional (finding)

```

## Service Type

The **Encounter.serviceType** element describes the service to be performed during the encounter. This element is connected to other resources such as Appointment (Appointment.serviceType), HealthcareService (HealthcareService.type) or Schedule (Schedule.serviceType)



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-encounter",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-encounter",
  "version" : "1.2.0",
  "name" : "EncounterProfile",
  "title" : "Encounter Profile",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the Encounter Resource",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Encounter",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter",
        "short" : "Encounter Profile",
        "definition" : "The Encounter Profile is based upon the core FHIR Encounter Resource"
      },
      {
        "id" : "Encounter.identifier",
        "path" : "Encounter.identifier",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.status",
        "path" : "Encounter.status",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.class",
        "path" : "Encounter.class",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.type",
        "path" : "Encounter.type",
        "comment" : "The binding strength of this element is [Preferred](https://www.hl7.org/fhir/terminologies.html#strength), meaning that codes are encouraged to draw from the SNOMED CT code system for interoperability purposes but are not required to do so to be considered conformant.",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "description" : "Valueset to describe the Encounter Type",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/encountertype"
        }
      },
      {
        "id" : "Encounter.subject",
        "path" : "Encounter.subject",
        "short" : "The patient present at the encounter",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.participant",
        "path" : "Encounter.participant",
        "short" : "A list of Practitioners participating in the encounter",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.participant.individual",
        "path" : "Encounter.participant.individual",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.reasonCode",
        "path" : "Encounter.reasonCode",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.reasonReference",
        "path" : "Encounter.reasonReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-condition",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-procedure",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-immunizationrecommendation"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.diagnosis",
        "path" : "Encounter.diagnosis",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.diagnosis.condition",
        "path" : "Encounter.diagnosis.condition",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-condition",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-procedure"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.diagnosis.rank",
        "path" : "Encounter.diagnosis.rank",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.hospitalization",
        "path" : "Encounter.hospitalization",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.hospitalization.origin",
        "path" : "Encounter.hospitalization.origin",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-location",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.hospitalization.destination",
        "path" : "Encounter.hospitalization.destination",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-location",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.hospitalization.dischargeDisposition",
        "path" : "Encounter.hospitalization.dischargeDisposition",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "Discharge Disposition.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/encounterdischargedisposition"
        }
      },
      {
        "id" : "Encounter.location.location",
        "path" : "Encounter.location.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-location"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.serviceProvider",
        "path" : "Encounter.serviceProvider",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.partOf",
        "path" : "Encounter.partOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-encounter"
            ]
          }
        ]
      }
    ]
  }
}

```
