# Document Reference Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Document Reference Profile**

## Resource Profile: Document Reference Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-documentreference | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:DocumentReferenceProfile |

 
Proposed constraints on the DocumentReference resource for the minimal set of data required to reference to a document of any kind for any purpose. 

# CA Core DocumentReference Profile

This DocumentReference profile sets minimum expectations for mandatory core elements, constraints and value sets required to provide metadata about the document of any kind so that the document can be published, discovered and managed.

This profile defines core localisation concepts for use in an Canadian context.

## Mandatory Data Elements

All elements or attributes defined in FHIR have cardinality as part of their definition - a minimum number of required appearances and a maximum number.

Most elements in FHIR specification have a minimum cardinality of **0**, which means that they may be missing from a resource when it is exchanged between systems.

**Required elements:**

* status of the refence
* document referenced

## Must Support Data Elements

Some elements are labeled as MustSupport meaning that implementations that produce or consume resources SHALL provide "support" for the element in some meaningful way (see [Must Support](https://build.fhir.org/ig/HL7-Canada/ca-baseline/general-guidance.html#must-support) definition).

Following elements are marked as Must Support in the Canadian DocumentReference profile to aid record matching in databases.

**Must Support elements:**

* master version identifier
* kind of document
* categorization of document
* subject of the document
* document author
* document authenticator
* organization which maintains the document
* the document itself or URL
* context of the document content
* practice settings
* patient demographics

## Usage Note

The following are example usage scenarios for the DocumentReference profile.

* Publishing a new document. This can be done using the [IHE MHD Provide Document Bundle [ITI-65]](https://wiki.ihe.net/index.php/Mobile_access_to_Health_Documents_(MHD)) transaction that carries both the document and its metadata.
* Querying the document repository for specific document(s) matching various metadata parameters. This is similar to the IHE MHD Find Document References [ITI-67] transaction.

**Usages:**

* Refer to this Profile: [Procedure Profile](StructureDefinition-profile-procedure.md) and [ServiceRequest Profile for Results Reporting](StructureDefinition-profile-servicerequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-documentreference)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-documentreference.csv), [Excel](StructureDefinition-profile-documentreference.xlsx), [Schematron](StructureDefinition-profile-documentreference.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-documentreference",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-documentreference",
  "version" : "1.2.0",
  "name" : "DocumentReferenceProfile",
  "title" : "DocumentReference Profile for metadata about the document",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints on the DocumentReference resource for the minimal set of data required to reference to a document of any kind for any purpose.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "fhircomposition",
      "uri" : "http://hl7.org/fhir/composition",
      "name" : "FHIR Composition"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "xds",
      "uri" : "http://ihe.net/xds",
      "name" : "XDS metadata equivalent"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DocumentReference",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DocumentReference",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DocumentReference",
        "path" : "DocumentReference",
        "short" : "DocumentReference Profile",
        "definition" : "The DocumentReference Profile is based upon the core FHIR DocumentReference resource and created to define the minimal set of the document metadata required to discoverer and manage any kind of documents."
      },
      {
        "id" : "DocumentReference.masterIdentifier",
        "path" : "DocumentReference.masterIdentifier",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.type",
        "path" : "DocumentReference.type",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.category",
        "path" : "DocumentReference.category",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.subject",
        "path" : "DocumentReference.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.author",
        "path" : "DocumentReference.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.authenticator",
        "path" : "DocumentReference.authenticator",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.custodian",
        "path" : "DocumentReference.custodian",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment",
        "path" : "DocumentReference.content.attachment",
        "constraint" : [
          {
            "key" : "ca-baseline-documentreference-1",
            "severity" : "error",
            "human" : "DocumentReference.content.attachment.url or DocumentReference.content.attachment.data or both SHALL be present.",
            "expression" : "url.exists() or data.exists()",
            "xpath" : "f:url or f:content"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.context.encounter",
        "path" : "DocumentReference.context.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-encounter"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.context.practiceSetting",
        "path" : "DocumentReference.context.practiceSetting",
        "short" : "PractitionerSpecialty",
        "comment" : "The binding strength of this element is [Preferred](https://www.hl7.org/fhir/terminologies.html#strength), meaning that codes are encouraged to draw from the PractitionerSpecialty code system for interoperability purposes but are not required to do so to be considered conformant.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "description" : "Defines the clinical, medical, surgical or other healthcare-related service specialty of a practitioner who interacts, treats or provides such services to or for a patient.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/practitionerspecialty"
        }
      },
      {
        "id" : "DocumentReference.context.sourcePatientInfo",
        "path" : "DocumentReference.context.sourcePatientInfo",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
