# Diagnostic Report for Report and Note Exchange Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Diagnostic Report for Report and Note Exchange Profile**

## Resource Profile: Diagnostic Report for Report and Note Exchange Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-diagnosticreportnote | *Version*:1.2.0 |
| Draft as of 2024-12-13 | *Computable Name*:DiagnosticReportNoteProfile |

 
Proposed constraints and extensions on the Diagnostic Report Resource to support collection of diagnostic report information for reports and notes. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. 

# CA Core DiagnosticReport (Note) Profile

> This profile initially put forth placeholders for the value sets used in category and code. Further work is required to determine if this profile should align to the value set in use in US Core (https://www.hl7.org/fhir/us/core/ValueSet-us-core-diagnosticreport-category.html and https://www.hl7.org/fhir/us/core/ValueSet-us-core-diagnosticreport-report-and-note-codes.html) or if a Canadian value set needs to be created.
</blockquote> </div> This profile sets minimum expectations to support collection of diagnostic report information for reports and notes. Generated as a first step toward creating a set of Canadian Baseline FHIR profiles. It identifies which core elements, constraints and value sets SHALL be present in the resource instance when using this profile. This profile defines core localisation concepts for use in an Canadian context. ## Mandatory Data Elements All elements or attributes defined in FHIR have cardinality as part of their definition - a minimum number of required appearances and a maximum number. Most elements in FHIR specification have a minimum cardinality of **0**, which means that they may be missing from a resource when it is exchanged between systems. **Required elements:** * status of the diagnostic report * category of the diagnostic report * code that describes the diagnostic report * subject of the report * time when report was created ## Must Support Data Elements Some elements are labeled as MustSupport meaning that implementations that produce or consume resources SHALL provide "support" for the element in some meaningful way (see [Must Support](https://build.fhir.org/ig/HL7-Canada/ca-baseline/general-guidance.html#must-support) definition). Following elements are marked as Must Support in the Canadian DiagnosticReport Note profile to aid record matching in databases. **Must Support elements:** * status of the report * category that classifies the report * code that describes the diagnostic report * subject of the report * healthcare event this report is about * time when report was created * time when report was issued * diagnostic service responsible for report * Media that are part of this report * Attachments that are part of this report ## Usage Note

**Usages:**

* Refer to this Profile: [Immunization Profile](StructureDefinition-profile-immunization.md), [MedicationAdministration Profile](StructureDefinition-profile-medicationadministration.md), [MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md), [Procedure Profile](StructureDefinition-profile-procedure.md) and [ServiceRequest Profile for Results Reporting](StructureDefinition-profile-servicerequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-diagnosticreportnote)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-diagnosticreportnote.csv), [Excel](StructureDefinition-profile-diagnosticreportnote.xlsx), [Schematron](StructureDefinition-profile-diagnosticreportnote.sch) 

### Notes:



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-diagnosticreportnote",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-diagnosticreportnote",
  "version" : "1.2.0",
  "name" : "DiagnosticReportNoteProfile",
  "title" : "Diagnostic Report for Report and Note Exchange Profile",
  "status" : "draft",
  "date" : "2024-12-13",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the Diagnostic Report Resource to support collection of diagnostic report information for reports and notes.  Generated as a first step toward creating a set of Canadian Baseline FHIR profiles.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DiagnosticReport",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DiagnosticReport",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DiagnosticReport",
        "path" : "DiagnosticReport",
        "short" : "DiagnosticReport for Report and Note Profile",
        "definition" : "The DiagnosticReport Profile is based upon the core FHIR DiagnosticReport Resource"
      },
      {
        "id" : "DiagnosticReport.status",
        "path" : "DiagnosticReport.status",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Codes providing the status of a DiagnosticReport.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/diagnostic-report-status"
        }
      },
      {
        "id" : "DiagnosticReport.category",
        "path" : "DiagnosticReport.category",
        "comment" : "This profile does not currently put forth a Canadian value set for Diagnostic Report Categories. Further work is required to determine if this profile should align to the value set in use in US Core https://www.hl7.org/fhir/us/core/ValueSet-us-core-diagnosticreport-category.html or if a Canadian value set needs to be created.",
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.code",
        "path" : "DiagnosticReport.code",
        "comment" : "This profile does not currently put forth a Canadian value set for Diagnostic Report Codes. Further work is required to determine if this profile should align to the value set in use in US Core https://www.hl7.org/fhir/us/core/ValueSet-us-core-diagnosticreport-report-and-note-codes.html or if a Canadian value set needs to be created.",
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.subject",
        "path" : "DiagnosticReport.subject",
        "short" : "The patient that the diagnostic report refers to",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.encounter",
        "path" : "DiagnosticReport.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-encounter"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.effective[x]",
        "path" : "DiagnosticReport.effective[x]",
        "short" : "Time of report or note",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.issued",
        "path" : "DiagnosticReport.issued",
        "short" : "Date/Time this version of the DiagnosticReport was made available",
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.performer",
        "path" : "DiagnosticReport.performer",
        "short" : "Responsible Diagnostic Service",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.media",
        "path" : "DiagnosticReport.media",
        "short" : "Key images associated with this report",
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.presentedForm",
        "path" : "DiagnosticReport.presentedForm",
        "short" : "Entire report as issued",
        "mustSupport" : true
      }
    ]
  }
}

```
