# DiagnosticReport Profile for Laboratory Results Reporting - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **DiagnosticReport Profile for Laboratory Results Reporting**

## Resource Profile: DiagnosticReport Profile for Laboratory Results Reporting 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-diagnosticreport | *Version*:1.2.0 |
| Draft as of 2024-12-27 | *Computable Name*:DiagnosticReportProfile |

 
Proposed constraints on the DiagnosticReport resource for the minimal set of data to query and retrieve diagnostic reports associated with laboratory and other results 

# CA Core DiagnosticReport (Laboratory Results) Profile

This profile sets minimum expectations for the DiagnosticReport resource to record, search, and fetch laboratory results associated with a patient. It identifies which core elements, constraints and value sets SHALL be present in the resource instance when using this profile.

This profile defines core localisation concepts for use in an Canadian context.

## Mandatory Data Elements

All elements or attributes defined in FHIR have cardinality as part of their definition - a minimum number of required appearances and a maximum number.

Most elements in FHIR specification have a minimum cardinality of **0**, which means that they may be missing from a resource when it is exchanged between systems.

**Required elements:**

* status of the diagnostic report
* code that describes the diagnostic report

## Must Support Data Elements

Some elements are labeled as MustSupport meaning that implementations that produce or consume resources SHALL provide "support" for the element in some meaningful way (see [Must Support](https://build.fhir.org/ig/HL7-Canada/ca-baseline/general-guidance.html#must-support) definition).

Following elements are marked as Must Support in the Canadian DiagnosticReport profile to aid record matching in databases.

**Must Support elements:**

* code that describes the diagnostic report
* subject of the report
* healthcare event this report is about
* Observations that are part of this report

## Usage Note

The following are example usage scenarios for the DiagnosticReport profile.

* Query for lab reports belonging to a Patient
* Record or update a lab report for a specific Patient

**Usages:**

* Refer to this Profile: [Immunization Profile](StructureDefinition-profile-immunization.md), [MedicationAdministration Profile](StructureDefinition-profile-medicationadministration.md), [MedicationStatement Profile](StructureDefinition-profile-medicationstatement.md), [Procedure Profile](StructureDefinition-profile-procedure.md) and [ServiceRequest Profile for Results Reporting](StructureDefinition-profile-servicerequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-diagnosticreport)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-diagnosticreport.csv), [Excel](StructureDefinition-profile-diagnosticreport.xlsx), [Schematron](StructureDefinition-profile-diagnosticreport.sch) 

### Notes:

## Category

The **DiagnosticReport.category** element is required in this profile since a typical use would involve searching, sorting for Laboratory test(s) and Laboratory result(s).

Multiple categories are allowed using various categorization schemes but at least one SHALL come from the FHIR defined value set that includes codes from HL7v2 Table 0074.

## ConclusionCode

The **DiagnosticReport.conclusionCode** element represents codes with the summary conclusion (interpretation/impression) of the diagnostic report.

The Canada Health Infoway Health Concern Code identification of the clinical problems, conditions, diagnoses, symptoms, findings and complaints is provided as a sample only.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-diagnosticreport",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-diagnosticreport",
  "version" : "1.2.0",
  "name" : "DiagnosticReportProfile",
  "title" : "DiagnosticReport Profile for Laboratory Results Reporting",
  "status" : "draft",
  "date" : "2024-12-27",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints on the DiagnosticReport resource for the minimal set of data to query and retrieve diagnostic reports associated with laboratory and other results",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DiagnosticReport",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DiagnosticReport",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DiagnosticReport",
        "path" : "DiagnosticReport",
        "short" : "DiagnosticReport Profile",
        "definition" : "Diagnostic Report Profile is based upon the core FHIR DiagnosticReport resource and created to meet the Laboratory test(s) and Laboratory value(s)/result(s) requirements."
      },
      {
        "id" : "DiagnosticReport.extension:note",
        "path" : "DiagnosticReport.extension",
        "sliceName" : "note",
        "comment" : "This extension is used to preadopt the DiagnosticReport.note element that was introduced in FHIR R5. This was done to socialize a standardized method for conveying notes that apply to the entirety of a diagnostic report as is seen in some Canadian implementations (e.g., OLIS). Before using this extension in your implementation, consider if its fit-for-purpose/fit-for-use applicable for your needs. Users are encouraged to review the https://build.fhir.org/versions.html#extensions.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-DiagnosticReport.note"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.category",
        "path" : "DiagnosticReport.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.category:LabResult",
        "path" : "DiagnosticReport.category",
        "sliceName" : "LabResult",
        "definition" : "A code that classifies the Laboratory test(s) and Laboratory result(s). This is used for searching, sorting and display purposes.",
        "comment" : "Multiple categories are allowed using various categorization schemes but at least one SHALL come from the FHIR defined value set that includes codes from HL7v2 Table 0074",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "DiagnosticReport.category:LabResult.coding.system",
        "path" : "DiagnosticReport.category.coding.system",
        "min" : 1,
        "fixedUri" : "http://terminology.hl7.org/CodeSystem/v2-0074"
      },
      {
        "id" : "DiagnosticReport.code",
        "path" : "DiagnosticReport.code",
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.code.coding",
        "path" : "DiagnosticReport.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "DiagnosticReport.code.coding:LabResult",
        "path" : "DiagnosticReport.code.coding",
        "sliceName" : "LabResult",
        "definition" : "A code that classifies the Laboratory test(s) and Laboratory result(s). This is used for searching, sorting and display purposes.",
        "comment" : "The code SHALL be LOINC 11502-2 'Laboratory report' code"
      },
      {
        "id" : "DiagnosticReport.code.coding:LabResult.system",
        "path" : "DiagnosticReport.code.coding.system",
        "min" : 1,
        "max" : "1",
        "fixedUri" : "http://loinc.org"
      },
      {
        "id" : "DiagnosticReport.code.coding:LabResult.code",
        "path" : "DiagnosticReport.code.coding.code",
        "min" : 1,
        "max" : "1",
        "fixedCode" : "11502-2"
      },
      {
        "id" : "DiagnosticReport.code.coding:@default",
        "path" : "DiagnosticReport.code.coding",
        "sliceName" : "@default",
        "definition" : "A code that classifies the report(s) or result(s). This is used for searching, sorting and display purposes.",
        "comment" : "It is preferrable that the coding comes from the LOINC code system"
      },
      {
        "id" : "DiagnosticReport.code.coding:@default.system",
        "path" : "DiagnosticReport.code.coding.system",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "DiagnosticReport.code.coding:@default.code",
        "path" : "DiagnosticReport.code.coding.code",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "DiagnosticReport.subject",
        "path" : "DiagnosticReport.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-location"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.encounter",
        "path" : "DiagnosticReport.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-encounter"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.effective[x]",
        "path" : "DiagnosticReport.effective[x]",
        "short" : "Time of the report or note",
        "definition" : "This is the Datetime or Period when the report or note was written.",
        "type" : [
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "DiagnosticReport.performer",
        "path" : "DiagnosticReport.performer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.resultsInterpreter",
        "path" : "DiagnosticReport.resultsInterpreter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-organization"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.specimen",
        "path" : "DiagnosticReport.specimen",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Specimen"]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.specimen:LabResult",
        "path" : "DiagnosticReport.specimen",
        "sliceName" : "LabResult",
        "comment" : "Details about the specimen(s) on which this laboratory report is based on."
      },
      {
        "id" : "DiagnosticReport.specimen:@default",
        "path" : "DiagnosticReport.specimen",
        "sliceName" : "@default",
        "comment" : "Details about specimen(s) on which this report is based on.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "DiagnosticReport.result",
        "path" : "DiagnosticReport.result",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.result:LabResult",
        "path" : "DiagnosticReport.result",
        "sliceName" : "LabResult",
        "comment" : "Observations that represent results produced by laboratory tests or panels/studies",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation-results"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.result:@default",
        "path" : "DiagnosticReport.result",
        "sliceName" : "@default",
        "comment" : "Observations that represent results produced for report",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-observation"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DiagnosticReport.conclusionCode",
        "path" : "DiagnosticReport.conclusionCode",
        "short" : "CHI identification of the condition, problem or diagnosis",
        "definition" : "The code that represents relevant clinical problems, conditions, diagnoses, symptoms, findings and complaints taken from [CHI Health Concern Code](https://fhir.infoway-inforoute.ca/ValueSet/healthconcerncode)",
        "comment" : "The binding strength of this element is [Example](https://www.hl7.org/fhir/terminologies.html#strength), meaning that the Canada Health Infoway Health Concern Code value set provides examples of the types of concepts intended to be included",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "Represents the patient's relevant clinical problems, conditions, diagnoses, symptoms, findings and complaints, as interpreted by the provider.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/healthconcerncode"
        }
      }
    ]
  }
}

```
