# Device Profile (Implantable) - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Device Profile (Implantable)**

## Resource Profile: Device Profile (Implantable) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device | *Version*:1.2.0 |
| Draft as of 2024-12-27 | *Computable Name*:DeviceProfile |

 
Proposed constraints on the Device resource for the minimal set of data to query and retrieve a patient's implantable device. 

# CA Baseline Device (Implantable) Profile

> This profile is seeking broader community and implementer feedback on this profile.

The clinical substream review of this profile is paused until a Subject Matter Expert can be found who can speak to the use of implantable device data in Canada. Due to a lack of current Canadian FHIR implementation guides that surface a device profile - this profile has not undergone a Due Diligence Review and should be treated with caution until more community feedback can be acquired.[Simplifier issue log for this profile](https://simplifier.net/CanadianFHIRBaselineProfilesCA-Core/deviceprofileimplantable/~issues).

This profile sets minimum expectations for the Device resource to record, search, and fetch UDI information associated with a patient's implantable device(s). It identifies which core elements SHALL be present in the resource when using this profile.

This profile defines core localization concepts for use in the Canadian context.

## Mandatory Data Elements

All elements or attributes within the FHIR specification have cardinality as part of their definition - a minimum number of required appearances and a maximum number of allowable appearances.

Most elements in the FHIR specification have a minimum cardinality of 0, so most elements are not required and subsequently they may be missing from a resource when it is exchanged between systems.

**Required elements in the Device (Implantable) profile:**

* A Unique Device Identifier (UDI) numeric or alphanumeric code (Device.deviceIdentifier): 
* either as the Human Readable Form (HRF) string representation of the barcode (Device.carrierHRF)
* or the Automatic Identification and Data Capture representation (Device.carrierAIDC)
 
* The type of the device (Device.type)
* A patient (Device.patient)

## Must Support Data Elements

Some elements are marked as Must Support. This means that implementations generating, receiving, or otherwise using resources with Must Support elements SHALL provide support for those elements in some meaningful way (see Must Support definition).

The following elements are marked as Must Support in the Device (Implantable) profile:

**Must Support elements:**

* Unique Device Identifier (UDI) Barcode string
* distinct identification string
* device manufacturer
* expiration date/time of the device
* lot number of manufacture
* serial number assigned by the manufacturer
* name of the device
* type of the device
* version of the device
* patient

## Usage Note

The following are example usage scenarios for the implantable Device profile:

* Query for a patient's implantable devices
* Record or update a patient implantable device information

**Usages:**

* Refer to this Profile: [Device Profile (Implantable)](StructureDefinition-profile-device.md), [DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-profile-diagnosticreport.md), [DocumentReference Profile for metadata about the document](StructureDefinition-profile-documentreference.md), [MedicationAdministration Profile](StructureDefinition-profile-medicationadministration.md)...Show 4 more,[MedicationDispense Profile](StructureDefinition-profile-medicationdispense.md),[MedicationRequest Profile](StructureDefinition-profile-medicationrequest.md),[Procedure Profile](StructureDefinition-profile-procedure.md)and[ServiceRequest Profile for Results Reporting](StructureDefinition-profile-servicerequest.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-device)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-device.csv), [Excel](StructureDefinition-profile-device.xlsx), [Schematron](StructureDefinition-profile-device.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-device",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device",
  "version" : "1.2.0",
  "name" : "DeviceProfile",
  "title" : "Device Profile (Implantable)",
  "status" : "draft",
  "date" : "2024-12-27",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints on the Device resource for the minimal set of data to query and retrieve a patient's implantable device.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "udi",
      "uri" : "http://fda.gov/UDI",
      "name" : "UDI Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Device",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Device",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Device",
        "path" : "Device",
        "short" : "Device Profile",
        "definition" : "The Device Profile is based upon the core FHIR Device Resource",
        "constraint" : [
          {
            "key" : "ca-device-1",
            "severity" : "warning",
            "human" : "Implantable medical devices that have UDI information MAY represent this information in either carrierAIDC or carrierHRF.",
            "expression" : "udiCarrier.empty() or (udiCarrier.carrierAIDC.exists() or udiCarrier.carrierHRF.exists())",
            "xpath" : "not(f:udiCarrier) or (f:carrierHRF or f:carrierAIDC)"
          },
          {
            "key" : "ca-device-2",
            "severity" : "warning",
            "human" : "For implantable medical devices that have UDI information, at least one of the Production Identifiers (UDI-PI) MAY be present.",
            "expression" : "udiCarrier.empty() or (manufactureDate.exists() or expirationDate.exists() or lotNumber.exists() or serialNumber.exists() or distinctIdentifier.exists())",
            "xpath" : "not(f:udiCarrier) or (f:manufactureDate or f:expirationDate or f:lotNumber or f:serialNumber or f:distinctIdentifier)"
          }
        ]
      },
      {
        "id" : "Device.udiCarrier",
        "path" : "Device.udiCarrier",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Device.udiCarrier.deviceIdentifier",
        "path" : "Device.udiCarrier.deviceIdentifier",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Device.udiCarrier.carrierAIDC",
        "path" : "Device.udiCarrier.carrierAIDC",
        "mustSupport" : true
      },
      {
        "id" : "Device.udiCarrier.carrierHRF",
        "path" : "Device.udiCarrier.carrierHRF",
        "mustSupport" : true
      },
      {
        "id" : "Device.distinctIdentifier",
        "path" : "Device.distinctIdentifier",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Device.manufacturer",
        "path" : "Device.manufacturer",
        "mustSupport" : true
      },
      {
        "id" : "Device.expirationDate",
        "path" : "Device.expirationDate",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Device.lotNumber",
        "path" : "Device.lotNumber",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Device.serialNumber",
        "path" : "Device.serialNumber",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Device.deviceName",
        "path" : "Device.deviceName",
        "mustSupport" : true
      },
      {
        "id" : "Device.type",
        "path" : "Device.type",
        "comment" : "The device-kind and device-type valueSets used in HL7 are identical. This profile currently mainatins the binding on device-kind because it is currently hosted in THO and is therefor expected to be updated more frequently",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Codes to identify medical devices",
          "valueSet" : "http://terminology.hl7.org/ValueSet/device-kind"
        }
      },
      {
        "id" : "Device.version",
        "path" : "Device.version",
        "mustSupport" : true
      },
      {
        "id" : "Device.patient",
        "path" : "Device.patient",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ]
      },
      {
        "id" : "Device.parent",
        "path" : "Device.parent",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device"
            ]
          }
        ]
      }
    ]
  }
}

```
