# Device Profile (Medical and Non-medical) - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Device Profile (Medical and Non-medical)**

## Resource Profile: Device Profile (Medical and Non-medical) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device-medical | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:DeviceProfileMedical |

 
Proposed constraints on the Device resource for the minimal set of data to query and retrieve a medical or non-medical device. 

# CA Baseline Device (Medical and Non-medical) Profile

This profile sets minimum expectations for the Device resource to record and search for medical and non-medical devices, wearable devices personal health devices, virtual devices such as computer programs and systems, etc., except patient's implantable device(s). It identifies which core elements SHALL be present in the resource when using this profile.

This profile defines core localization concepts for use in the Canadian context.

## Mandatory Data Elements

All elements or attributes within the FHIR specification have cardinality as part of their definition - a minimum number of required appearances and a maximum number of allowable appearances.

Most elements in the FHIR specification have a minimum cardinality of 0, so most elements are not required and subsequently they may be missing from a resource when it is exchanged between systems.

**Required elements in the Device (Implantable) profile:**

* The type of the device (Device.type)

## Must Support Data Elements

Some elements are marked as Must Support. This means that implementations generating, receiving, or otherwise using resources with Must Support elements SHALL provide support for those elements in some meaningful way (see Must Support definition).

The following elements are marked as Must Support in the Device (Medical and Non-medical) profile:

**Must Support elements:**

* Device resource identifier
* Unique Device Identifier (UDI) Barcode string
* distinct identification string
* device manufacturer
* date/time when the device was made
* expiration date/time of the device
* serial number assigned by the manufacturer
* name of the device
* type of the device
* version of the device
* patient

## Usage Note

The following are example usage scenarios for the Medical and Non-medical Device profile:

* To record and query information about Personal Health Devices (PHDs) to be used in remote patient monitoring programs.
* To record and query information about the Virtual Medical Device installed as software on the computer system.

**Usages:**

* Refer to this Profile: [Device Profile (Medical and Non-medical)](StructureDefinition-profile-device-medical.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-device-medical)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-device-medical.csv), [Excel](StructureDefinition-profile-device-medical.xlsx), [Schematron](StructureDefinition-profile-device-medical.sch) 

### Notes:

## Identifier

The **Device.identifier** specifies a unique instance identifiers assigned to a device by manufacturer. This Device profile constrains the use of the Extended Unique Identifier (EUI) such as 64-bit Extended Unique Identifier (EUI-64) or 48-bit Extended Unique Identifier (EUI-48) by fixing the **Identifier.system** namespace for the identifier value.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-device-medical",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device-medical",
  "version" : "1.2.0",
  "name" : "DeviceProfileMedical",
  "title" : "Device Profile (Medical and Non-medical)",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints on the Device resource for the minimal set of data to query and retrieve a medical or non-medical device.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "udi",
      "uri" : "http://fda.gov/UDI",
      "name" : "UDI Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Device",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Device",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Device",
        "path" : "Device",
        "short" : "Device Profile",
        "definition" : "The Device Profile is based upon the core FHIR Device Resource"
      },
      {
        "id" : "Device.identifier",
        "path" : "Device.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Device.identifier.type",
        "path" : "Device.identifier.type",
        "mustSupport" : true
      },
      {
        "id" : "Device.identifier.system",
        "path" : "Device.identifier.system",
        "mustSupport" : true
      },
      {
        "id" : "Device.identifier.value",
        "path" : "Device.identifier.value",
        "short" : "The value that is unique within the system.",
        "mustSupport" : true
      },
      {
        "id" : "Device.identifier:EUI-64",
        "path" : "Device.identifier",
        "sliceName" : "EUI-64",
        "short" : "IEEE 64-bit Extended Unique Identifier (EUI-64)",
        "max" : "1"
      },
      {
        "id" : "Device.identifier:EUI-64.system",
        "path" : "Device.identifier.system",
        "short" : "EUI-64 system identifier",
        "min" : 1,
        "fixedUri" : "urn:oid:1.2.840.10004.1.1.1.0.0.1.0.0.1.2680"
      },
      {
        "id" : "Device.identifier:EUI-64.value",
        "path" : "Device.identifier.value",
        "min" : 1
      },
      {
        "id" : "Device.identifier:EUI-48",
        "path" : "Device.identifier",
        "sliceName" : "EUI-48",
        "short" : "MAC Transport address identifier (EUI-48)",
        "max" : "1"
      },
      {
        "id" : "Device.identifier:EUI-48.system",
        "path" : "Device.identifier.system",
        "short" : "EUI-48 system identifier",
        "min" : 1,
        "fixedUri" : "http://terminology.hl7.org/fhir/sid/eui-48"
      },
      {
        "id" : "Device.identifier:EUI-48.value",
        "path" : "Device.identifier.value",
        "min" : 1
      },
      {
        "id" : "Device.udiCarrier",
        "path" : "Device.udiCarrier",
        "mustSupport" : true
      },
      {
        "id" : "Device.udiCarrier.deviceIdentifier",
        "path" : "Device.udiCarrier.deviceIdentifier",
        "mustSupport" : true
      },
      {
        "id" : "Device.udiCarrier.carrierAIDC",
        "path" : "Device.udiCarrier.carrierAIDC",
        "mustSupport" : true
      },
      {
        "id" : "Device.udiCarrier.carrierHRF",
        "path" : "Device.udiCarrier.carrierHRF",
        "mustSupport" : true
      },
      {
        "id" : "Device.distinctIdentifier",
        "path" : "Device.distinctIdentifier",
        "mustSupport" : true
      },
      {
        "id" : "Device.manufacturer",
        "path" : "Device.manufacturer",
        "mustSupport" : true
      },
      {
        "id" : "Device.manufactureDate",
        "path" : "Device.manufactureDate",
        "mustSupport" : true
      },
      {
        "id" : "Device.expirationDate",
        "path" : "Device.expirationDate",
        "mustSupport" : true
      },
      {
        "id" : "Device.serialNumber",
        "path" : "Device.serialNumber",
        "mustSupport" : true
      },
      {
        "id" : "Device.deviceName",
        "path" : "Device.deviceName",
        "mustSupport" : true
      },
      {
        "id" : "Device.type",
        "path" : "Device.type",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Codes to identify medical devices",
          "valueSet" : "http://hl7.org/fhir/ValueSet/device-kind"
        }
      },
      {
        "id" : "Device.version",
        "path" : "Device.version",
        "mustSupport" : true
      },
      {
        "id" : "Device.patient",
        "path" : "Device.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Device.parent",
        "path" : "Device.parent",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-device-medical"
            ]
          }
        ]
      }
    ]
  }
}

```
