# AllergyIntolerance Profile - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **AllergyIntolerance Profile**

## Resource Profile: AllergyIntolerance Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-allergyintolerance | *Version*:1.2.0 |
| Draft as of 2024-11-24 | *Computable Name*:AllergyIntoleranceProfile |

 
Proposed constraints and extensions on the AllergyIntolerance Resource 

# CA Baseline AllergyIntolerance Profile

This profile sets minimum expectations for the AllergyIntolerance resource to record, search and fetch allergies/adverse reactions associated with a patient. It documents the relevant allergies or intolerances (conditions) for a patient, describing the kind of reaction, agent(s) that cause it, criticality and the certainty of the allergy/adverse reaction.

This profile defines localization concepts for use in the Canadian context.

## Mandatory Data Elements

All elements or attributes within the FHIR specification have cardinality as part of their definition - a minimum number of required appearances and a maximum number of allowable appearances.

Most elements in the FHIR specification have a minimum cardinality of 0, so most elements are not required and subsequently they may be missing from a resource when it is exchanged between systems.

**Required elements in the AllergyIntolerance profile:**

* subject who has the allergy or intolerance (AllergyIntolerance.patient)

## Must Support Data Elements

Some elements are marked as Must Support. This means that implementations generating, receiving, or otherwise using resources with Must Support elements SHALL provide support for those elements in some meaningful way (see [Must Support](https://build.fhir.org/ig/HL7-Canada/ca-baseline/general-guidance.html#cardinality-and-mustsupport-definitions) definition).

The following elements are marked as Must Support in the AllergyIntolerance profile:

**Must Support elements:**

* code of the allergy or intolerance (AllergyIntolerance.code)
* reference to a subject (AllergyIntolerance.patient)
* manifestation of clinical symptoms (AllergyIntolerance.reaction.manifestation)

## Usage Note

The **AllergyIntolerance** resource instance use could be clinical decision support applications to generate/display warnings about potentially harmful medications; any intolerance to other agents (e.g. intolerance to soaps, dressings, latex, etc.) more relevant for at the bedside care.

This profile utilizes and recommends some value sets that exist on the Infoway Terminology Gateway and can be assessed by API. Implementors using and/or re-profiling from this profile should be aware that the IGPublisher can not directly resolve the canonical url to value sets that exist on the Infoway Terminology Gateway due to technical limitations and will produce warnings in the qa.txt file when this occurs. These particular warnings have been suppressed in this specification and will need to be suppressed by other IGuide authors looking to leverage this particular service until the limitations are resolved.

### Profile specific implementation guidance

**History of Allergy or Intolerance**

If the patient has been asked and has indicated a history of allergy or intolerance then this information is represented by:

* **AllergyIntolerance.code** - an appropriate SNOMED CT code
*  

| | | |
| :--- | :--- | :--- |
| **AllergyIntolerance.verificationStatus**element SHALL be one of the following: confirmed | refuted | entered-in-error |

 

If a patient asserts a history of allergy or intolerance then the following elements SHOULD be populated:

* **AllergyIntolerance.criticality**
* **AllergyIntolerance.severity**
* **AllergyIntolerance.type**

**No Allergy**

If a patient has been asked and has indicated no history of allergies or intolerance then this is represented by:

* **AllergyIntolerance.code** = "716186003" No known allergy (situation) SNOMED CT code
*  

| | | |
| :--- | :--- | :--- |
| **AllergyIntolerance.verificationStatus**element SHALL be one of the following: confirmed | refuted | entered-in-error |

 

**Not Asked**

If the patient has NOT been asked or it is NOT possible to obtain information about any history of allergy or intolerance then this situation is represented with NullFlavor codes:

* **AllergyIntolerance.code** - NullFalvor code, e.g., "NASK" (Not asked).

If NullFlavor is used then the following elements SHOULD NOT be populated:

* **AllergyIntolerance.clinicalStatus**
* **AllergyIntolerance.verificationStatus**
* **AllergyIntolerance.type**
* **AllergyIntolerance.category**
* **AllergyIntolerance.criticality**

and other allergy related elements.

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/profile-allergyintolerance)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-profile-allergyintolerance.csv), [Excel](StructureDefinition-profile-allergyintolerance.xlsx), [Schematron](StructureDefinition-profile-allergyintolerance.sch) 

### Notes:

## Verification Status

The **AllergyIntolerance.verificationStatus** element is optional (i.e., cardinality is 0..1) in this profile since a typical use would involve clinical decision support that produces warnings when potentially dangerous medications/treatments might be prescribed.

There is potential for confounding/conflicting information if verification status "overrides" a clinical finding of an allergy or intolerance.

In addition allergies/intolerance are usually reported by the patient and rarely verified probable that this information is not collected and not available, therefore data element is not populated except by default (presumably as "unconfirmed") again leading to problematic data for clinical decision support.

This is also problematic with respect to interoperability considerations.

## Code

If the **AllergyIntolerance.code** element represents NullFlavor concept (i.e., no known allergy) then the **verificationStatus** element SHALL be present.

Rational is that recording "no known allergy" without an assessment would a patient safety issue and should not happen. It is not consistent with clinical practice.

## Substance

The identification of the specific substance (or pharmaceutical product) considered to be responsible for the Adverse Reaction event uses Substance Code value set with [Example](https://hl7.org/fhir/R4/terminologies.html#example) binding. Consider use [Canadian Clinical Drug Data](https://tgateway.infoway-inforoute.ca/package/canadianclinicaldrugdatasetccdd) set in case of medication allergy/intolerance, and SNOMED CT for other substances/agents.

## Manifestation

The **AllergyIntolerance.reaction.manifestation** element is a required element to provide symptoms and/or signs that are observed or associated with the adverse reaction event.

```
-Consider developing a value set from MEDDRA for drug reactions

```



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "profile-allergyintolerance",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-allergyintolerance",
  "version" : "1.2.0",
  "name" : "AllergyIntoleranceProfile",
  "title" : "AllergyIntolerance Profile",
  "status" : "draft",
  "date" : "2024-11-24",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Proposed constraints and extensions on the AllergyIntolerance Resource",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AllergyIntolerance",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/AllergyIntolerance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AllergyIntolerance",
        "path" : "AllergyIntolerance",
        "short" : "AllergyIntolerance Profile",
        "definition" : "The AllergyIntolerance Profile is based upon the core FHIR AllergyIntolerance Resource",
        "constraint" : [
          {
            "key" : "ca-baseline-allergy",
            "severity" : "error",
            "human" : "AllergyIntolerance.verificationStatus SHALL be present if AllergyIntolerance.code represents NullFlavor concept",
            "expression" : "code.coding.where(system = 'http://terminology.hl7.org/CodeSystem/v3-NullFlavor').exists() implies verificationStatus.exists()",
            "xpath" : "f:code/f:coding/f:system/@value='https://fhir.infoway-inforoute.ca/ValueSet/NullFlavor' implies exists(f:verificationStatus)"
          },
          {
            "key" : "ca-baseline-allergy-notasked",
            "severity" : "error",
            "human" : "if AllergyIntolerance.code is a NullFlavor value, then AllergyIntolerance.clinicalStatus, AllergyIntolerance.type, AllergyIntolerance.category, AllergyIntolerance.criticality SHALL NOT be present",
            "expression" : "code.coding.where(system = 'http://terminology.hl7.org/CodeSystem/v3-NullFlavor').exists() implies type.exists().not() and category.exists().not() and criticality.exists().not()",
            "xpath" : "f:code/f:coding/f:system/@value='http://terminology.hl7.org/CodeSystem/v3-NullFlavor' and exists(f:type).not() and exists(f:category).not() and exists(f:criticality).not()"
          },
          {
            "key" : "ca-baseline-allergy-noallergy",
            "severity" : "error",
            "human" : "if AllergyIntolerance.code is '716186003' No known allergy, then AllergyIntolerance.verificationStatus SHALL be one of the following: confirmed | refuted | entered-in-error",
            "expression" : "code.coding.where(system = 'http://snomed.info/sct' and code = '716186003').exists() and verificationStatus.coding.where(code = 'unconfirmed').empty()",
            "xpath" : "f:code/f:coding/f:system/@value='http://snomed.info/sct' and exists(f:verificationStatus/f:coding/f:code/@value='unconfirmed').not()"
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.extension",
        "path" : "AllergyIntolerance.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "AllergyIntolerance.extension:abatement",
        "path" : "AllergyIntolerance.extension",
        "sliceName" : "abatement",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement"
            ]
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.identifier",
        "path" : "AllergyIntolerance.identifier"
      },
      {
        "id" : "AllergyIntolerance.clinicalStatus",
        "path" : "AllergyIntolerance.clinicalStatus",
        "isModifier" : true,
        "isModifierReason" : "This element is labeled as a modifier because the status contains the codes refuted and entered-in-error that mark the AllergyIntolerance as not currently valid."
      },
      {
        "id" : "AllergyIntolerance.verificationStatus",
        "path" : "AllergyIntolerance.verificationStatus",
        "isModifier" : true,
        "isModifierReason" : "This element is labeled as a modifier because the status contains the codes refuted and entered-in-error that mark the AllergyIntolerance as not currently valid."
      },
      {
        "id" : "AllergyIntolerance.category",
        "path" : "AllergyIntolerance.category",
        "comment" : "Some implementers may utilize value sets where category is readily distinguishable while others may not, and those that do not use those value sets should consider making category MS in their profiles"
      },
      {
        "id" : "AllergyIntolerance.code",
        "path" : "AllergyIntolerance.code",
        "min" : 0,
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.code.coding",
        "path" : "AllergyIntolerance.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "closed"
        },
        "min" : 0
      },
      {
        "id" : "AllergyIntolerance.code.coding:NotAsked",
        "path" : "AllergyIntolerance.code.coding",
        "sliceName" : "NotAsked",
        "short" : "Code for NOT asked or NOT possible to obtain information about allergy or intolerance",
        "definition" : "Code for the case when a patient has NOT been asked or it is NOT possible to obtain information about any history of allergy or intolerance.",
        "comment" : "The binding strength of this element is [Preferred](https://www.hl7.org/fhir/terminologies.html#strength), meaning that codes are encouraged to draw from the NullFlavor value set for interoperability purposes but are not required to do so to be considered conformant.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "Negation/exclusion codes for reporting no known allergies or not available data.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/NullFlavor"
        }
      },
      {
        "id" : "AllergyIntolerance.code.coding:NotAsked.system",
        "path" : "AllergyIntolerance.code.coding.system",
        "min" : 1,
        "fixedUri" : "http://terminology.hl7.org/fhir/v3/NullFlavor"
      },
      {
        "id" : "AllergyIntolerance.code.coding:NotAsked.code",
        "path" : "AllergyIntolerance.code.coding.code",
        "min" : 1
      },
      {
        "id" : "AllergyIntolerance.code.coding:NoAllergy",
        "path" : "AllergyIntolerance.code.coding",
        "sliceName" : "NoAllergy",
        "short" : "Code when a patient has been asked and has indicated no history of allergies or intolerance",
        "definition" : "Code for the case when a patient has been asked and has indicated no history of allergies or intolerance.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.code.coding:NoAllergy.system",
        "path" : "AllergyIntolerance.code.coding.system",
        "min" : 1,
        "fixedUri" : "http://snomed.info/sct"
      },
      {
        "id" : "AllergyIntolerance.code.coding:NoAllergy.code",
        "path" : "AllergyIntolerance.code.coding.code",
        "min" : 1,
        "fixedCode" : "716186003"
      },
      {
        "id" : "AllergyIntolerance.code.coding:@default",
        "path" : "AllergyIntolerance.code.coding",
        "sliceName" : "@default",
        "definition" : "Code for an allergy or intolerance statement. This may be a code for a substance or pharmaceutical product that is considered to be responsible for the adverse reaction risk, an allergy or intolerance condition.",
        "comment" : "The binding strength of this element is [Example](https://hl7.org/fhir/R4/terminologies.html#example), meaning that codes are not expected or even encouraged to draw from the specified value set to be conformant",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "AllergyIntoleranceCode"
            }
          ],
          "strength" : "example",
          "description" : "Type of the substance/product, allergy or intolerance condition.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/allergyintolerance-code"
        }
      },
      {
        "id" : "AllergyIntolerance.patient",
        "path" : "AllergyIntolerance.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.encounter",
        "path" : "AllergyIntolerance.encounter",
        "short" : "Encounter when the allergy or intolerance was asserted",
        "definition" : "The encounter when the allergy or intolerance was asserted.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-encounter"
            ]
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.onsetDateTime:onsetDateTime",
        "path" : "AllergyIntolerance.onsetDateTime",
        "sliceName" : "onsetDateTime",
        "comment" : "This slice was initially flagged as Must Support, and is considered MS in a handful of Canadian FHIR Implementation Guides. However, while clinically desireable it is not broadly considered MS across all IGuides reviewed during the Due Dilligence Review.",
        "min" : 0,
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.recorder",
        "path" : "AllergyIntolerance.recorder",
        "short" : "Who recorded the sensitivity",
        "definition" : "Individual who recorded the record and takes responsibility for its content.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient"
            ]
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.asserter",
        "path" : "AllergyIntolerance.asserter",
        "short" : "Source of the information about the allergy",
        "definition" : "The source of the information about the allergy that is recorded.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-patient",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitioner",
              "http://hl7.org/fhir/ca/baseline/StructureDefinition/profile-practitionerrole"
            ]
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.reaction.substance",
        "path" : "AllergyIntolerance.reaction.substance",
        "short" : "Specific substance or pharmaceutical product considered to be responsible for event"
      },
      {
        "id" : "AllergyIntolerance.reaction.substance.coding",
        "path" : "AllergyIntolerance.reaction.substance.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "closed"
        },
        "comment" : "This slice was initially identified with a 1..* cardinality, and has similar constraints in a handful of Canadian FHIR Implementation Guides. However, while clinically desireable to include coding, it was not constrained consistently across all IGuides reviewed during the Due Dilligence Review."
      },
      {
        "id" : "AllergyIntolerance.reaction.substance.coding:NonDrugAllergen",
        "path" : "AllergyIntolerance.reaction.substance.coding",
        "sliceName" : "NonDrugAllergen",
        "short" : "Code for the specific non-drug allergen",
        "definition" : "Code for the specific non-drug allergen or other agent/substance to which the Client has an allergic reaction.",
        "comment" : "The binding strength of this element is [Preferred](https://www.hl7.org/fhir/terminologies.html#strength), meaning that codes are encouraged to draw from the NonDrugAllergenCode value set for interoperability purposes but are not required to do so to be considered conformant.",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "Represents the specific non-drug allergen or other agent/substance to which the Client has an allergic reaction.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/NonDrugAllergenCode"
        }
      },
      {
        "id" : "AllergyIntolerance.reaction.substance.coding:NonDrugAllergen.system",
        "path" : "AllergyIntolerance.reaction.substance.coding.system",
        "min" : 1
      },
      {
        "id" : "AllergyIntolerance.reaction.substance.coding:NonDrugAllergen.code",
        "path" : "AllergyIntolerance.reaction.substance.coding.code",
        "min" : 1
      },
      {
        "id" : "AllergyIntolerance.reaction.substance.coding:CCDD",
        "path" : "AllergyIntolerance.reaction.substance.coding",
        "sliceName" : "CCDD",
        "short" : "Medicinal products for prescribing",
        "definition" : "The subset of codes with commonly used medicinal products that are available for prescribing and dispensing in Canada.",
        "comment" : "The binding strength of this element is [Preferred](https://www.hl7.org/fhir/terminologies.html#strength), meaning that codes are encouraged to draw from the PrescriptionMedicinalProduct value set for interoperability purposes but are not required to do so to be considered conformant.",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "Represents subset of codes with commonly used medicinal products that are available for prescribing and dispensing in Canada.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/prescriptionmedicinalproduct"
        }
      },
      {
        "id" : "AllergyIntolerance.reaction.substance.coding:CCDD.system",
        "path" : "AllergyIntolerance.reaction.substance.coding.system",
        "min" : 1,
        "fixedUri" : "https://fhir.infoway-inforoute.ca/CodeSystem/canadianclinicaldrugdataset"
      },
      {
        "id" : "AllergyIntolerance.reaction.substance.coding:CCDD.code",
        "path" : "AllergyIntolerance.reaction.substance.coding.code",
        "min" : 1
      },
      {
        "id" : "AllergyIntolerance.reaction.substance.coding:@default",
        "path" : "AllergyIntolerance.reaction.substance.coding",
        "sliceName" : "@default",
        "short" : "Specific substance or pharmaceutical product considered to be responsible for event",
        "definition" : "Identification of the specific substance (or pharmaceutical product) considered to be responsible for the Adverse Reaction event.",
        "comment" : "The binding strength of this element is [Example](https://hl7.org/fhir/R4/terminologies.html#example), meaning that codes are not expected or even encouraged to draw from the specified value set to be conformant",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "SubstanceCode"
            }
          ],
          "strength" : "example",
          "description" : "Codes defining the type of the substance (including pharmaceutical products).",
          "valueSet" : "http://hl7.org/fhir/ValueSet/substance-code"
        }
      },
      {
        "id" : "AllergyIntolerance.reaction.manifestation",
        "path" : "AllergyIntolerance.reaction.manifestation",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.reaction.exposureRoute",
        "path" : "AllergyIntolerance.reaction.exposureRoute",
        "short" : "How the subject was exposed to the substance",
        "definition" : "Identification of the route by which the subject was exposed to the substance.",
        "comment" : "The binding strength of this element is [Preferred](https://www.hl7.org/fhir/terminologies.html#strength), meaning that codes are encouraged to draw from the RouteOfAdministration value set for interoperability purposes but are not required to do so to be considered conformant.",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "A coded concept describing the route or physiological path of administration of a therapeutic agent into or onto the body of a subject.",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/RouteOfAdministration"
        }
      }
    ]
  }
}

```
