# Service Language - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Service Language**

## Extension: Service Language 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-servicelanguage | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:ExtensionServiceLanguage |

Identifies languages that services are provided in.

**Context of Use**

Identifies a language that is used to services are provide services at a Location or Organization.

**Note** this extension was created to meet the requirement of [ext-location-language](https://simplifier.net/ProvincialProviderRe/organizationLanguage) extension used in the ON PPR guide which is semantically different than Resource.language. The implementation is different, with the intent of being more consistent with the Communication element on the Patient and Practitioner resources.

**Usage info**

**Usages:**

* Use this Extension: [Location Profile](StructureDefinition-profile-location.md) and [Organization Profile](StructureDefinition-profile-organization.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/ext-servicelanguage)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-servicelanguage.csv), [Excel](StructureDefinition-ext-servicelanguage.xlsx), [Schematron](StructureDefinition-ext-servicelanguage.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-servicelanguage",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-servicelanguage",
  "version" : "1.2.0",
  "name" : "ExtensionServiceLanguage",
  "title" : "Extension: ServiceLanguage",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Identifies languages that services are provided in.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Organization"
    },
    {
      "type" : "element",
      "expression" : "Location"
    },
    {
      "type" : "element",
      "expression" : "HealthcareService"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Languages used to provide services",
        "definition" : "Indentifies languages that services are provided in at the location.",
        "isModifier" : false
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-servicelanguage"
      },
      {
        "id" : "Extension.valueCodeableConcept",
        "path" : "Extension.valueCodeableConcept",
        "binding" : {
          "strength" : "preferred",
          "description" : "Common Languages",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      }
    ]
  }
}

```
