# Role Status - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Role Status**

## Extension: Role Status 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-rolestatus | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:ExtensionRoleStatus |

This extension applies to the PractitionerRole resource and indicates the possible states of the Role, as defined by the HL7v3 Role class state machine.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [PractitionerRole Profile (Provider Registry)](StructureDefinition-profile-practitionerrole-registry.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/ext-rolestatus)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-rolestatus.csv), [Excel](StructureDefinition-ext-rolestatus.xlsx), [Schematron](StructureDefinition-ext-rolestatus.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-rolestatus",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-rolestatus",
  "version" : "1.2.0",
  "name" : "ExtensionRoleStatus",
  "title" : "Extension: RoleStatus",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "This extension applies to the PractitionerRole resource and indicates the possible states of the Role, as defined by the HL7v3 Role class state machine.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "PractitionerRole"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "RoleStatus extension",
        "definition" : "Represents the status of the Role, as defined by the HL7v3 Role class state machine.",
        "comment" : "The roleStatus extension has been flagged for further implementer feedback regarding whether it should be considered a modifier extension given that the status code may provide additional knowledge about the PractitionerRole resource that modifies its meaning or interpretation",
        "max" : "1",
        "mapping" : [
          {
            "identity" : "rim",
            "map" : "RoleStatus",
            "comment" : "Codes representing the defined possible states of the Role"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "min" : 1,
        "max" : "1",
        "fixedUri" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-rolestatus"
      },
      {
        "id" : "Extension.valueCode",
        "path" : "Extension.valueCode",
        "short" : "normal | active | cancelled | pending | suspended | terminated | nullified",
        "definition" : "Code representing the defined possible states of a practitioner",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-RoleStatus"
        }
      }
    ]
  }
}

```
