# Birth Sex - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Birth Sex**

## Extension: Birth Sex 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-patientbirthsex | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:ExtensionBirthSex |

A code classifying the person's sex assigned at birth. Replicates the birthsex extension in US-Core-R4 for interoperability.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Patient Profile](StructureDefinition-profile-patient.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/ext-patientbirthsex)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-patientbirthsex.csv), [Excel](StructureDefinition-ext-patientbirthsex.xlsx), [Schematron](StructureDefinition-ext-patientbirthsex.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-patientbirthsex",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-patientbirthsex",
  "version" : "1.2.0",
  "name" : "ExtensionBirthSex",
  "title" : "Extension: Birth Sex",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "A code classifying the person's sex assigned at birth. Replicates the birthsex extension in US-Core-R4 for interoperability.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "A code classifying the person's sex assigned at birth. Replicates the birthsex extension in US-Core-R4 for interoperability.",
        "comment" : "The codes required are intended to present birth sex (i.e., the sex recorded on the patient’s birth certificate) and not gender identity or reassigned sex.",
        "max" : "1",
        "isModifier" : false,
        "mapping" : [
          {
            "identity" : "rim",
            "map" : "player[classCode=PSN|ANM and determinerCode=INSTANCE]/administrativeGender"
          },
          {
            "identity" : "iso11179",
            "map" : ".patient.administrativeGenderCode"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-patientbirthsex",
        "mustSupport" : true
      },
      {
        "id" : "Extension.valueCoding",
        "path" : "Extension.valueCoding",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "example",
          "description" : "Code for sex assigned at birth",
          "valueSet" : "http://hl7.org/fhir/ca/baseline/ValueSet/birthsex"
        }
      },
      {
        "id" : "Extension.valueCoding.system",
        "path" : "Extension.valueCoding.system",
        "min" : 1
      },
      {
        "id" : "Extension.valueCoding.code",
        "path" : "Extension.valueCoding.code",
        "min" : 1
      },
      {
        "id" : "Extension.valueCoding.display",
        "path" : "Extension.valueCoding.display",
        "short" : "Optional description of the sex at birth code",
        "definition" : "Plain text representation of the sex at birth concept"
      }
    ]
  }
}

```
