# Identifier Version - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Identifier Version**

## Extension: Identifier Version 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-identifierversion | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:ExtensionIdentifierVersion |

A version string indicating the currency/validity of an identifier

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Patient Profile](StructureDefinition-profile-patient.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/ext-identifierversion)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-identifierversion.csv), [Excel](StructureDefinition-ext-identifierversion.xlsx), [Schematron](StructureDefinition-ext-identifierversion.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-identifierversion",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-identifierversion",
  "version" : "1.2.0",
  "name" : "ExtensionIdentifierVersion",
  "title" : "Extension: Identifier Version",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "A version string indicating the currency/validity of an identifier",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient.identifier"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "A code indicating a specific version of an identifier credential",
        "comment" : "For example, a health card version number, credit card version number, etc.  Used to help verify the authenticity of a credential",
        "max" : "1",
        "mustSupport" : false
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-identifierversion"
      },
      {
        "id" : "Extension.valueString",
        "path" : "Extension.valueString",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
