# Date Estimated Flag - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Date Estimated Flag**

## Extension: Date Estimated Flag 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-dateestimated | *Version*:1.2.0 |
| Draft as of 2024-08-09 | *Computable Name*:ExtensionDateEstimatedFlag |

If true, indicates that information entered is an estimate and may not be precise

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Immunization Profile](StructureDefinition-profile-immunization.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/ext-dateestimated)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-dateestimated.csv), [Excel](StructureDefinition-ext-dateestimated.xlsx), [Schematron](StructureDefinition-ext-dateestimated.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-dateestimated",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-dateestimated",
  "version" : "1.2.0",
  "name" : "ExtensionDateEstimatedFlag",
  "title" : "Extension: Date Estimated Flag",
  "status" : "draft",
  "date" : "2024-08-09",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "If true, indicates that information entered is an estimate and may not be precise",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "dateTime"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Information entered is is an estimate",
        "definition" : "If true, information entered may not be accurate or precise",
        "isModifier" : false
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-dateestimated"
      },
      {
        "id" : "Extension.valueBoolean",
        "path" : "Extension.valueBoolean",
        "min" : 1
      }
    ]
  }
}

```
