# Aboriginal Identity Group - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Aboriginal Identity Group**

## Extension: Aboriginal Identity Group 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-aboriginalidentitygroup | *Version*:1.2.0 |
| Draft as of 2024-08-01 | *Computable Name*:ExtensionAboriginalIdentityGroup |

A code classifying the person's aboriginal identity

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Patient Profile](StructureDefinition-profile-patient.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.ca.baseline|current/StructureDefinition/ext-aboriginalidentitygroup)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-aboriginalidentitygroup.csv), [Excel](StructureDefinition-ext-aboriginalidentitygroup.xlsx), [Schematron](StructureDefinition-ext-aboriginalidentitygroup.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-aboriginalidentitygroup",
  "url" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-aboriginalidentitygroup",
  "version" : "1.2.0",
  "name" : "ExtensionAboriginalIdentityGroup",
  "title" : "Extension: Aboriginal Identity Group",
  "status" : "draft",
  "date" : "2024-08-01",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "A code classifying the person's aboriginal identity",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "A code classifying the person's aboriginal identity",
        "min" : 0,
        "max" : "1",
        "isModifier" : false
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "min" : 1,
        "max" : "1",
        "fixedUri" : "http://hl7.org/fhir/ca/baseline/StructureDefinition/ext-aboriginalidentitygroup"
      },
      {
        "id" : "Extension.valueCoding",
        "path" : "Extension.valueCoding",
        "definition" : "Concepts classifying the person's aboriginal identity sharing common history, traits or geographical origin",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "preferred",
          "description" : "One of [aboriginal identity codes](https://fhir.infoway-inforoute.ca/ValueSet/aboriginalidentitygroup)",
          "valueSet" : "https://fhir.infoway-inforoute.ca/ValueSet/aboriginalidentitygroup"
        }
      },
      {
        "id" : "Extension.valueCoding.system",
        "path" : "Extension.valueCoding.system",
        "short" : "Identity of the terminology system",
        "min" : 1
      },
      {
        "id" : "Extension.valueCoding.code",
        "path" : "Extension.valueCoding.code",
        "short" : "Code defining aboriginal identity concept",
        "definition" : "One of [aboriginal identity codes](https://fhir.infoway-inforoute.ca/ValueSet/aboriginalidentitygroup)",
        "min" : 1
      },
      {
        "id" : "Extension.valueCoding.display",
        "path" : "Extension.valueCoding.display",
        "short" : "Optional description of the aboriginal identity code",
        "definition" : "Plain text representation of the aboriginal identity concept"
      }
    ]
  }
}

```
