# Aboriginal Identity Type - Canadian Baseline v1.2.0

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](allartifacts.md)
* [**Artifact List**](artifacts.md)
* **Aboriginal Identity Type**

## CodeSystem: Aboriginal Identity Type 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.infoway-inforoute.ca/CodeSystem/aboriginalidentitytype | *Version*:1.2.0 |
| Draft as of 2025-10-10 | *Computable Name*:AboriginalIdentityType |

 
Represents codes for Aboriginal Identity 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "aboriginalidentitytype",
  "url" : "https://fhir.infoway-inforoute.ca/CodeSystem/aboriginalidentitytype",
  "version" : "1.2.0",
  "name" : "AboriginalIdentityType",
  "title" : "Aboriginal Identity Type",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-10T19:18:14+00:00",
  "publisher" : "HL7 Canada - FHIR Implementation Work Group",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://infocentral.infoway-inforoute.ca/en/collaboration/wg/fhir-implementations"
        }
      ]
    }
  ],
  "description" : "Represents codes for Aboriginal Identity",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CA"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "firstnations",
      "display" : "First Nations",
      "designation" : [
        {
          "language" : "en",
          "value" : "First Nations"
        }
      ]
    },
    {
      "code" : "inuit",
      "display" : "Inuit",
      "designation" : [
        {
          "language" : "en",
          "value" : "Inuit"
        }
      ]
    },
    {
      "code" : "metis",
      "display" : "Metis",
      "designation" : [
        {
          "language" : "en",
          "value" : "Metis"
        }
      ]
    },
    {
      "code" : "firstnations-inuit",
      "display" : "First Nations and Inuit",
      "designation" : [
        {
          "language" : "en",
          "value" : "First Nations and Inuit"
        }
      ]
    },
    {
      "code" : "firstnations-metis",
      "display" : "First Nations and Metis",
      "designation" : [
        {
          "language" : "en",
          "value" : "First Nations and Metis"
        }
      ]
    },
    {
      "code" : "firstnations-inuit-metis",
      "display" : "First Nations, Inuit and Metis",
      "designation" : [
        {
          "language" : "en",
          "value" : "First Nations, Inuit and Metis"
        }
      ]
    },
    {
      "code" : "inuit-metis",
      "display" : "Inuit and Metis",
      "designation" : [
        {
          "language" : "en",
          "value" : "Inuit and Metis"
        }
      ]
    }
  ]
}

```
